/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.utils;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.IdentifiedCache;
import org.qubership.atp.dataset.model.Identified;

public class StrongIdentifiedCache
implements IdentifiedCache {
    private Map<Class<? extends Identified>, Map<UUID, ? extends Identified>> caches = null;

    public StrongIdentifiedCache() {
        this(null);
    }

    public StrongIdentifiedCache(@Nullable Map<Class<? extends Identified>, Map<UUID, ? extends Identified>> caches) {
        this.caches = caches;
    }

    @Override
    @Nonnull
    public <T extends Identified> T computeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
        return (T)this.getCache(type).computeIfAbsent(id, uuid -> (Identified)Preconditions.checkNotNull((Object)((Identified)sourceFunc.apply((UUID)uuid)), (String)"[%s] with id [%s] is not provided by [%s]", (Object)type, (Object)id, (Object)sourceFunc));
    }

    @Override
    @Nullable
    public <T extends Identified> T getIfPresent(@Nonnull Class<T> type, @Nonnull UUID id) {
        if (this.caches == null) {
            return null;
        }
        Map<UUID, ? extends Identified> cache = this.caches.get(type);
        if (cache == null) {
            return null;
        }
        return (T)cache.get(id);
    }

    @Override
    public <T extends Identified> void put(@Nonnull Class<T> type, @Nonnull T identified) {
        this.getCache(type).put(identified.getId(), identified);
    }

    @Override
    public void clear() {
        if (this.caches == null) {
            return;
        }
        for (Map<UUID, ? extends Identified> cache : this.caches.values()) {
            cache.clear();
        }
    }

    @Nonnull
    private <T extends Identified> Map<UUID, T> getCache(@Nonnull Class<T> type) {
        Map<UUID, Identified> cache;
        if (this.caches == null) {
            this.caches = new HashMap<Class<? extends Identified>, Map<UUID, ? extends Identified>>();
        }
        if ((cache = this.caches.get(type)) == null) {
            cache = this.createCache();
            this.caches.put(type, cache);
        }
        return cache;
    }

    private <T extends Identified> Map<UUID, T> createCache() {
        return new HashMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrongIdentifiedCache that = (StrongIdentifiedCache)o;
        return Objects.equals(this.caches, that.caches);
    }

    public int hashCode() {
        return Objects.hash(this.caches);
    }
}

