/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.kafka.handlers.project.strategies;

import org.qubership.atp.dataset.kafka.entities.project.EventType;
import org.qubership.atp.dataset.kafka.entities.project.ProjectEvent;
import org.qubership.atp.dataset.kafka.handlers.project.ProcessingStrategy;
import org.qubership.atp.dataset.service.direct.VisibilityAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, matchIfMissing=false)
public class DeleteProjectProcessingStrategy
implements ProcessingStrategy<ProjectEvent, EventType> {
    public static final String PROJECTS_CACHE_NAME = "projects";
    @Autowired
    private VisibilityAreaService visibilityAreaService;

    @Override
    @CacheEvict(value={"projects"}, key="#projectEvent.getProjectId()")
    public void process(ProjectEvent projectEvent) {
        this.visibilityAreaService.delete(projectEvent.getProjectId());
    }

    @Override
    public EventType getIdentifier() {
        return EventType.DELETE;
    }
}

