/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DotSeparatedArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.macros.args.MacroArgFactory;
import org.qubership.atp.dataset.macros.args.MacroArgsFactory;
import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.macros.args.SignatureArg;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReferenceToDslMacros
extends Macros<String> {
    public static final String MACROS_DEFINITION = "REF_DSL";
    @Autowired
    private MacroArgsFactory args;

    public ReferenceToDslMacros() {
        super(MACROS_DEFINITION);
    }

    private static String evaluate(@Nonnull RefArg<DataSetList> dslArg, @Nonnull RefArg<DataSet> dsArg, @Nonnull List<RefArg<Attribute>> attrArgs, @Nonnull EvaluationContext context) throws Exception {
        ImmutableList argsList = ImmutableList.builder().add(dslArg).add(dsArg).addAll(attrArgs).build();
        context.resolveArguments((List<? extends RefArg<?>>)argsList);
        DataSetList dsl = dslArg.get();
        DataSet ds = dsArg.get();
        if (!ds.getDataSetList().equals(dsl)) {
            throw new Exception("Can not search for reference: no such data set found " + argsList.stream().map(Objects::toString).collect(Collectors.joining(".")));
        }
        OverlapItem refItem = (OverlapItem)OverlapIterator.create(ds, attrArgs.get(attrArgs.size() - 1).get().getId(), attrArgs.stream().limit(attrArgs.size() - 1).map(refArg -> ((Attribute)refArg.get()).getId()).collect(Collectors.toList())).next();
        if (!refItem.isReachable()) {
            throw new Exception("Can not find reference " + argsList.stream().map(Objects::toString).collect(Collectors.joining(".")));
        }
        OverlapItem.Reachable reachable = refItem.asReachable();
        Optional<Parameter> paramOpt = reachable.getParameter();
        if (!paramOpt.isPresent()) {
            return "";
        }
        Parameter parameter = paramOpt.get();
        Optional<String> valueOpt = reachable.getValue();
        if (!valueOpt.isPresent()) {
            return "";
        }
        String value = valueOpt.get();
        if (value.isEmpty()) {
            return value;
        }
        return context.evaluate(reachable, parameter, value);
    }

    @Override
    public String evaluate(Stream<? extends MacroArg> args, EvaluationContext context) throws Exception {
        Iterator iterator = args.iterator();
        MacroArg first = (MacroArg)iterator.next();
        RefArg dslArg = (RefArg)first.asRef().flatMap(RefArg::asDsl).orElseThrow(() -> new IllegalArgumentException("Expected dsl as 1st parameter, got: " + first));
        MacroArg second = (MacroArg)iterator.next();
        RefArg dsArg = (RefArg)second.asRef().flatMap(RefArg::asDs).orElseThrow(() -> new IllegalArgumentException("Expected ds as 2nd parameter, got: " + second));
        LinkedList<RefArg> attrArgs = new LinkedList<RefArg>();
        int i = 3;
        while (iterator.hasNext()) {
            MacroArg next = (MacroArg)iterator.next();
            int itemIdx = i++;
            RefArg attr = (RefArg)next.asRef().flatMap(RefArg::asAttr).orElseThrow(() -> new IllegalArgumentException("Expected attr as " + itemIdx + " parameter, got: " + next));
            attrArgs.add(attr);
        }
        try {
            return context.executeInAnyContext(context.getStrictContexts(), ctx -> {
                List<RefArg<Attribute>> relativeAttrArgs = context.relativizePathFromSharedToThis(ctx, attrArgs);
                return ReferenceToDslMacros.evaluate(dslArg, dsArg, relativeAttrArgs, ctx);
            });
        }
        catch (Exception e) {
            Iterator<? extends EvaluationContext> nonStrict = context.getNonStrictContexts();
            if (!nonStrict.hasNext()) {
                throw e;
            }
            try {
                return context.executeInAnyContext(nonStrict, ctx -> ReferenceToDslMacros.evaluate(dslArg, dsArg, attrArgs, ctx));
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
    }

    @Override
    public ArgsParser createArgsParser() {
        return new DotSeparatedArgsParser(this.args){

            @Override
            protected SignatureArg createArg(int index, @Nonnull MacroArgFactory args) throws Exception {
                switch (index) {
                    case 0: {
                        return args.dsl();
                    }
                    case 1: {
                        return args.ds();
                    }
                }
                return args.attr();
            }
        };
    }

    @Override
    public boolean doCache() {
        return false;
    }
}

