/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.parser;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.parser.ParsingState;
import org.qubership.atp.dataset.macros.parser.Strategy;
import org.qubership.atp.dataset.macros.parser.Token;

public class TokensIterator
implements Iterator<Token> {
    private final ParsingState state;
    private final StringBuilder tail;
    private final Queue<Token> pushed = new ArrayDeque<Token>(2);

    public TokensIterator(MacroRegistry macroFinder, StringBuilder tail) {
        this.tail = tail;
        this.state = new ParsingState(macroFinder){

            @Override
            protected void pushToken(Strategy strategy) {
                super.pushToken(strategy);
                TokensIterator.this.pushed.add(strategy);
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.tail.length() > 0 || !this.pushed.isEmpty() || !this.state.currentStrategy.consumed;
    }

    @Override
    public Token next() {
        int i;
        for (i = 0; this.pushed.isEmpty() && i < this.tail.length(); ++i) {
            char chr = this.tail.charAt(i);
            this.state.read(chr);
        }
        if (i > 0) {
            this.tail.delete(0, i);
        }
        if (!this.pushed.isEmpty()) {
            return this.pushed.remove();
        }
        if (!this.state.currentStrategy.consumed) {
            this.state.currentStrategy.consumed = true;
            return this.state.currentStrategy;
        }
        throw new NoSuchElementException();
    }

    public void notifyReduce() {
        this.state.brackets.goDeeper();
    }

    public void reset() {
        this.pushed.clear();
        this.state.reset();
    }
}

