/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportModel;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.utils.ImportUtils;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractAttributeConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractAttributeConverter.class);
    private static final int ATTR_NAME_ROW_INDEX = 0;

    protected boolean isAttributeShouldOverlap(AttributeImportModel importModel, DatasetParameterValue datasetParameterValue, AttributeImportContext importContext, Predicate<Parameter> parameterPredicate) {
        boolean isDslSubAttribute;
        String attributeName = importModel.getName();
        log.debug("Checking is attribute '{}' should be overlapped", (Object)attributeName);
        String datasetName = datasetParameterValue.getDatasetName();
        String refDatasetListName = datasetParameterValue.getDatasetListReference();
        String refDatasetName = datasetParameterValue.getDatasetReference();
        log.debug("DS name: {}, DSL ref: {}, DS ref: {}", new Object[]{attributeName, refDatasetListName, refDatasetName});
        String attributeKey = importModel.getKey();
        String value = datasetParameterValue.getTextValue();
        boolean isDslAttribute = ImportUtils.isArrowDelimiterPresent(attributeKey);
        String overlapKey = ImportUtils.getOverlapKey(datasetName, attributeKey);
        boolean isOverlapExist = importContext.isOverlapExist(overlapKey);
        if (isOverlapExist) {
            log.debug("Is Overlap Exist key: {}, value {}, Dataset name {}", new Object[]{overlapKey, value, datasetName});
            return true;
        }
        if (isDslAttribute) {
            log.debug("Check if parent DSL attribute doesn't have DS reference");
            AttributeImportModel parent = importModel.getParent();
            DatasetParameterValue parentDatasetParameterValue = parent.getDatasetParameterValue(datasetName);
            String parentDatasetReference = parentDatasetParameterValue.getDatasetReference();
            boolean isDslAttributeWithoutDsRef = StringUtils.isEmpty((Object)parentDatasetReference);
            if (isDslAttributeWithoutDsRef) {
                log.debug("Parent DSL '{}' attribute doesn't have DS reference", (Object)parent.getName());
                return !StringUtils.isEmpty((Object)value);
            }
        }
        if (isDslSubAttribute = this.isDslSubAttribute(datasetParameterValue)) {
            boolean isParameterValueChanged;
            String refAttributeKey = this.getRefAttributeKey(importModel, datasetParameterValue);
            log.debug("Ref attribute key: {}", (Object)refAttributeKey);
            Parameter refParameter = importContext.getRefParameter(refAttributeKey);
            log.debug("Ref parameter: {}", (Object)refParameter);
            boolean isRefParameter = Objects.isNull(refParameter);
            if (isRefParameter) {
                return !StringUtils.isEmpty((Object)value);
            }
            try {
                isParameterValueChanged = parameterPredicate.test(refParameter);
            }
            catch (NullPointerException e) {
                log.warn("Parameter value is '{}', Attribute key: '{}',  datasetParameterValue: '{}'", new Object[]{e.getCause(), attributeKey, datasetParameterValue});
                isParameterValueChanged = false;
            }
            log.debug("Parameter should be overlapped");
            return isParameterValueChanged;
        }
        log.debug("Parameter shouldn't be overlapped");
        return false;
    }

    protected String getRefAttributeKey(AttributeImportModel importModel, DatasetParameterValue childDatasetParameterValue) {
        DatasetParameterValue datasetParameterValue;
        AttributeType type = importModel.getType();
        String attributeName = importModel.getName();
        log.debug("Get key for reference attribute with name '{}' and type '{}'", (Object)attributeName, (Object)type);
        if (AttributeType.DSL.equals((Object)type)) {
            AttributeImportModel parent = importModel.getParent();
            String parentDatasetName = childDatasetParameterValue.getDatasetName();
            datasetParameterValue = parent.getDatasetParameterValue(parentDatasetName);
        } else {
            datasetParameterValue = childDatasetParameterValue;
        }
        String refAttributeKey = ImportUtils.getDsParameterKey(datasetParameterValue, attributeName);
        log.debug("Result ref attribute key: {}", (Object)refAttributeKey);
        return refAttributeKey;
    }

    protected boolean isDslSubAttribute(DatasetParameterValue datasetParameterValue) {
        log.debug("Detects if dataset parameter value '{}' is DSL sub attribute", (Object)datasetParameterValue);
        String datasetListReference = datasetParameterValue.getDatasetListReference();
        String datasetReference = datasetParameterValue.getDatasetReference();
        log.debug("DSL reference: {}, DS reference: {}", (Object)datasetListReference, (Object)datasetReference);
        boolean isDslSubAttribute = org.apache.commons.lang.StringUtils.isNotEmpty((String)datasetListReference) && org.apache.commons.lang.StringUtils.isNotEmpty((String)datasetReference);
        log.debug("Is DSl sub attribute: {}", (Object)isDslSubAttribute);
        return isDslSubAttribute;
    }

    protected UUID getDatasetReference(DatasetParameterValue datasetParameterValue, AttributeImportContext context) {
        UUID datasetId;
        log.debug("Get dataset id for dataset parameter value: {}", (Object)datasetParameterValue);
        if (this.isDslSubAttribute(datasetParameterValue)) {
            String datasetListReference = datasetParameterValue.getDatasetListReference();
            String datasetReference = datasetParameterValue.getDatasetReference();
            String datasetKey = ImportUtils.getDatasetKey(datasetListReference, datasetReference);
            log.debug("Dataset key: {}", (Object)datasetKey);
            datasetId = context.getRefDatasetId(datasetKey);
        } else {
            datasetId = datasetParameterValue.getDatasetId();
        }
        log.debug("Found dataset id: {}", (Object)datasetId);
        return datasetId;
    }

    protected String getAttributeName(Map<Integer, String> row) {
        log.debug("Get attribute name for excel row");
        Object attributeName = ImportUtils.getCellValue(row, 0);
        log.debug("Cell attribute name value: {}", attributeName);
        if (ImportUtils.isArrowDelimiterPresent((String)attributeName)) {
            Object[] dslAttributeNameParts = ((String)attributeName).split(" -> ");
            log.debug("DSL attribute name parts: {}", (Object)Arrays.toString(dslAttributeNameParts));
            int dslAttributeNamePartsIndex = dslAttributeNameParts.length - 1;
            attributeName = dslAttributeNameParts[dslAttributeNamePartsIndex];
        }
        log.debug("Result attribute name: {}", attributeName);
        return attributeName;
    }

    protected String getAttributeKey(Map<Integer, String> row) {
        log.debug("Get attribute name for excel row");
        return ImportUtils.getCellValue(row, 0);
    }

    protected String getRowAttributeName(Map<Integer, String> row) {
        log.debug("Get row attribute name");
        return ImportUtils.getCellValue(row, 0);
    }

    protected AttributeImportModel mapTextRowToImportModel(Map<Integer, String> row, AttributeImportContext importContext) {
        String key = this.getAttributeKey(row);
        Attribute attribute = importContext.getAttribute(key);
        UUID id = attribute.getId();
        String name = this.getAttributeName(row);
        String cellType = ImportUtils.getAttributeType(row).toUpperCase();
        AttributeType type = AttributeType.valueOf(cellType);
        boolean isDslAttribute = AttributeType.DSL.equals((Object)type);
        log.debug("Map attribute '{}' row with type '{}' to import model", (Object)name, (Object)type);
        AttributeImportModel importModel = new AttributeImportModel(id, name, key, type);
        List<DatasetParameterValue> datasetParameterValues = importContext.getDatasetsCellIndexMap().entrySet().stream().map(entry -> {
            Integer datasetCellIndex = (Integer)entry.getValue();
            String datasetName = (String)entry.getKey();
            String dsParamValue = ImportUtils.getCellValue(row, datasetCellIndex);
            UUID datasetId = importContext.getDatasetId(datasetName);
            if (isDslAttribute) {
                String dslRefName = attribute.getTypeDataSetList().getName();
                String dsRefName = ImportUtils.getParameterDsRefName(dsParamValue);
                importModel.setDatasetListReference(dslRefName);
                log.debug("Set values: datasetId='{}', datasetName='{}', dsParamValue='{}', dslRefName='{}', dsRefName='{}'", new Object[]{datasetId, datasetName, dsParamValue, dslRefName, dsRefName});
                return new DatasetParameterValue(datasetId, datasetName, dsParamValue, dslRefName, dsRefName);
            }
            log.debug("Set values: datasetId='{}', datasetName='{}', dsParamValue='{}'", new Object[]{datasetId, datasetName, dsParamValue});
            return new DatasetParameterValue(datasetId, datasetName, dsParamValue);
        }).collect(Collectors.toList());
        importModel.setDatasetParameterValues(datasetParameterValues);
        return importModel;
    }

    protected String getParamValueTarget(boolean attributeShouldOverlap, DatasetParameterValue datasetParameterValue, AttributeImportContext importContext, UUID attributeId, UUID datasetId, AttributeImportModel importModel, ParameterService parameterService) {
        if (!attributeShouldOverlap) {
            log.debug("is not Overlap, attributeId: {}, datasetId: {}", (Object)attributeId, (Object)datasetId);
            return this.getValueTarget(datasetParameterValue, importModel, importContext, attributeId, datasetId, parameterService);
        }
        String paramOverlapValueTarget = importContext.getTargetDslOverlaps().get(datasetParameterValue.getDatasetName() + "_" + importModel.getKey());
        log.debug("is overlap, attributeId: {}, datasetId: {}, paramOverlapValueTarget: {}", new Object[]{attributeId, datasetId, paramOverlapValueTarget});
        return Objects.isNull(paramOverlapValueTarget) ? this.getValueTarget(datasetParameterValue, importModel, importContext, attributeId, datasetId, parameterService) : paramOverlapValueTarget;
    }

    private String getValueTarget(DatasetParameterValue datasetParameterValue, AttributeImportModel importModel, AttributeImportContext importContext, UUID attributeId, UUID datasetId, ParameterService parameterService) {
        String valueTarget = "";
        UUID targetRefDatasetId = importContext.getRefDatasetsNameIdMap().get(datasetParameterValue.getDatasetListReference() + "_" + datasetParameterValue.getDatasetReference());
        targetRefDatasetId = Objects.isNull(targetRefDatasetId) ? datasetId : targetRefDatasetId;
        Parameter parameterTarget = parameterService.getByDataSetIdAttributeId(targetRefDatasetId, attributeId);
        if (Objects.nonNull(parameterTarget)) {
            AttributeType type = importModel.getType();
            if (AttributeType.LIST.equals((Object)type)) {
                ListValue targetListValueValue = parameterTarget.getListValue();
                valueTarget = Objects.nonNull(targetListValueValue) ? targetListValueValue.getName() : valueTarget;
            } else if (AttributeType.TEXT.equals((Object)type)) {
                valueTarget = parameterTarget.getText();
            }
        }
        return valueTarget;
    }
}

