/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefThisMacro
extends AbstractMacro {
    private static final Logger LOG = LoggerFactory.getLogger(RefThisMacro.class);
    public static final String MACRO_NAME = "REF_THIS";

    public RefThisMacro(String realMacroName, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        super(realMacroName, macroContext, parameterPositionContext);
    }

    @Override
    public String getEvaluatedValue(List<String> arguments) {
        if (Objects.isNull(arguments)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return "";
        }
        String[] splits = String.join((CharSequence)"", arguments).split("\\.");
        LinkedList<PathStep> pathSteps = new LinkedList<PathStep>();
        for (int i = 0; i < splits.length - 1; ++i) {
            pathSteps.add(new PathStep(splits[i]));
        }
        PathStep attribute = new PathStep(splits[splits.length - 1]);
        String result = this.getMacroContext().getTextParameterFromCachedContextByNamesPath(this.getParameterPositionContext(), pathSteps, attribute);
        return result;
    }

    @Override
    public String getUnevaluatedValue(String childrenValue) {
        if (StringUtils.isEmpty((String)childrenValue)) {
            return super.getUnevaluatedValue(childrenValue);
        }
        try {
            String[] splits;
            LinkedList<String> content = new LinkedList<String>();
            for (String split : splits = childrenValue.split("\\.")) {
                if (Utils.isUuid(split)) {
                    String attributeName = this.getMacroContext().getAttributeName(UUID.fromString(split));
                    if (attributeName == null) {
                        attributeName = split;
                    }
                    content.add(attributeName);
                    continue;
                }
                content.add(split);
            }
            return super.getUnevaluatedValue(StringUtils.join(content, (String)"."));
        }
        catch (Exception e) {
            LOG.debug("Error macro values translation", (Throwable)e);
            return super.getUnevaluatedValue(childrenValue);
        }
    }
}

