/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemResponseDto;
import org.qubership.atp.dataset.service.rest.dto.versioning.UiManDataSetListJDto;
import org.qubership.atp.dataset.service.rest.server.HistoryControllerApi;
import org.qubership.atp.dataset.versioning.service.JaversHistoryService;
import org.qubership.atp.dataset.versioning.service.RestoreService;
import org.qubership.atp.dataset.versioning.service.RevisionDetailsService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoryController
implements HistoryControllerApi {
    private final JaversHistoryService javersHistoryService;
    private final RevisionDetailsService revisionDetailsService;
    private final RestoreService restoreService;

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @AuditAction(auditAction="Get all history for project: {{#projectId}}")
    public ResponseEntity<HistoryItemResponseDto> getAllHistory(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="id") UUID id, @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @Valid @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) {
        HistoryItemResponseDto response = this.javersHistoryService.getAllHistory(id, offset, limit);
        return ResponseEntity.ok((Object)response);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'READ')")
    @AuditAction(auditAction="Get revision details for project: {{#projectId}}")
    public ResponseEntity<UiManDataSetListJDto> getRevisionDetails(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="entityId") UUID entityId, @PathVariable(value="revision") Integer revision) {
        UiManDataSetListJDto revisionDetails = this.revisionDetailsService.getRevisionDetails(revision, entityId);
        return ResponseEntity.ok((Object)revisionDetails);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'UPDATE')")
    @AuditAction(auditAction="Restore to revision: {{#revisionId}}")
    public ResponseEntity<Void> restoreToRevision(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="id") UUID id, @PathVariable(value="revisionId") Integer revisionId) {
        this.restoreService.restore(id, revisionId);
        return ResponseEntity.ok().build();
    }

    public HistoryController(JaversHistoryService javersHistoryService, RevisionDetailsService revisionDetailsService, RestoreService restoreService) {
        this.javersHistoryService = javersHistoryService;
        this.revisionDetailsService = revisionDetailsService;
        this.restoreService = restoreService;
    }
}

