/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.model.Filter;
import org.qubership.atp.dataset.service.direct.FilterService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/filter"})
public class LabelFilterController {
    private FilterService filterService;

    @Autowired
    public LabelFilterController(FilterService filterService) {
        this.filterService = filterService;
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/create"})
    @AuditAction(auditAction="Create new filter for project: {{#vaId}}")
    @Operation(summary="Create new filter")
    public Filter createFilter(@RequestParam(value="name") String name, @RequestParam(value="vaId") UUID vaId, @RequestBody(required=false) Map<String, List<UUID>> labels) {
        List<UUID> dsLabels = this.getLabelsOrEmptyList(labels, "dsLabels");
        List<UUID> dslLabels = this.getLabelsOrEmptyList(labels, "dslLabels");
        Preconditions.checkNotNull((Object)name, (Object)"Query parameter 'name' should not be null");
        Preconditions.checkNotNull((Object)name, (Object)"Query parameter 'vaId' should not be null");
        return this.filterService.create(name, vaId, dsLabels, dslLabels);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/get"})
    @AuditAction(auditAction="Get filters for project: {{#vaId}}")
    @Operation(summary="Returns all filter under visibility area")
    public List<Filter> getFilters(@RequestParam(value="vaId", required=false) UUID vaId) {
        return this.filterService.getAll(vaId);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PutMapping(value={"/update"})
    @AuditAction(auditAction="Update filter: {{#filterId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Update filter name and filter labels")
    public void update(@RequestParam(value="name", required=false) String name, @RequestParam(value="filterId", required=false) UUID filterId, @RequestBody(required=false) Map<String, List<UUID>> labels) {
        List<UUID> dsLabels = this.getLabelsOrEmptyList(labels, "dsLabels");
        List<UUID> dslLabels = this.getLabelsOrEmptyList(labels, "dslLabels");
        this.filterService.update(filterId, name, dsLabels, dslLabels);
    }

    private List<UUID> getLabelsOrEmptyList(Map<String, List<UUID>> labels, String dslLabels) {
        return labels.computeIfAbsent(dslLabels, key -> Collections.emptyList());
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @DeleteMapping(value={"/delete"})
    @AuditAction(auditAction="Delete filter: {{#filterId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete filter by id")
    public void delete(@RequestParam(value="filterId") UUID filterId) {
        this.filterService.delete(filterId);
    }
}

