/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.domain;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.model.domain.ListValueSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;

@Value
public class AttributeSnapshot {
    private final AttributeTypeName type;
    private final Integer ordering;
    private final List<ListValueSnapshot> listValues = new LinkedList<ListValueSnapshot>();
    private final List<ParameterSnapshot> parameters = new LinkedList<ParameterSnapshot>();
    private final UUID id;
    private final String name;
    private final UUID dataSetListReference;

    public AttributeSnapshot(Attribute model) {
        this.id = model.getId();
        this.name = model.getName();
        this.type = model.getAttributeType();
        this.dataSetListReference = model.getTypeDataSetListId();
        this.ordering = model.getOrdering();
        for (ListValue listValue : model.getListValues()) {
            this.listValues.add(new ListValueSnapshot(listValue));
        }
        for (Parameter parameter : model.getParameters()) {
            this.parameters.add(new ParameterSnapshot(parameter));
        }
    }

    public Set<UUID> getParametersIds() {
        return this.getParameters().stream().map(ParameterSnapshot::getId).collect(Collectors.toSet());
    }

    public ParameterSnapshot getParameterById(UUID parameterId) {
        for (ParameterSnapshot parameter : this.getParameters()) {
            if (!parameter.getId().equals(parameterId)) continue;
            return parameter;
        }
        return null;
    }

    public Set<UUID> getListValuesIds() {
        return this.getListValues().stream().map(ListValueSnapshot::getId).collect(Collectors.toSet());
    }

    public ListValueSnapshot getListValueById(UUID listValueId) {
        for (ListValueSnapshot listValue : this.getListValues()) {
            if (!listValue.getId().equals(listValueId)) continue;
            return listValue;
        }
        return null;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public Integer getOrdering() {
        return this.ordering;
    }

    public List<ListValueSnapshot> getListValues() {
        return this.listValues;
    }

    public List<ParameterSnapshot> getParameters() {
        return this.parameters;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public UUID getDataSetListReference() {
        return this.dataSetListReference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeSnapshot)) {
            return false;
        }
        AttributeSnapshot other = (AttributeSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$ordering = this.getOrdering();
        Integer other$ordering = other.getOrdering();
        if (this$ordering == null ? other$ordering != null : !((Object)this$ordering).equals(other$ordering)) {
            return false;
        }
        AttributeTypeName this$type = this.getType();
        AttributeTypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<ListValueSnapshot> this$listValues = this.getListValues();
        List<ListValueSnapshot> other$listValues = other.getListValues();
        if (this$listValues == null ? other$listValues != null : !((Object)this$listValues).equals(other$listValues)) {
            return false;
        }
        List<ParameterSnapshot> this$parameters = this.getParameters();
        List<ParameterSnapshot> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$dataSetListReference = this.getDataSetListReference();
        UUID other$dataSetListReference = other.getDataSetListReference();
        return !(this$dataSetListReference == null ? other$dataSetListReference != null : !((Object)this$dataSetListReference).equals(other$dataSetListReference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $ordering = this.getOrdering();
        result = result * 59 + ($ordering == null ? 43 : ((Object)$ordering).hashCode());
        AttributeTypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<ListValueSnapshot> $listValues = this.getListValues();
        result = result * 59 + ($listValues == null ? 43 : ((Object)$listValues).hashCode());
        List<ParameterSnapshot> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $dataSetListReference = this.getDataSetListReference();
        result = result * 59 + ($dataSetListReference == null ? 43 : ((Object)$dataSetListReference).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeSnapshot(type=" + (Object)((Object)this.getType()) + ", ordering=" + this.getOrdering() + ", listValues=" + this.getListValues() + ", parameters=" + this.getParameters() + ", id=" + this.getId() + ", name=" + this.getName() + ", dataSetListReference=" + this.getDataSetListReference() + ")";
    }
}

