/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import java.util.UUID;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.metamodel.object.InstanceId;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=6)
public class DeleteAttributeProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(DeleteAttributeProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<SetChange> setChangesDataSetListAttributes = DeleteAttributeProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, SetChange.class, "DataSetList", "attributes");
        if (!setChangesDataSetListAttributes.isEmpty()) {
            List removedAttributesIds = setChangesDataSetListAttributes.get(0).getRemovedValues();
            return !removedAttributesIds.isEmpty();
        }
        return false;
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        SetChange setChangesDataSetListAttributes = DeleteAttributeProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, SetChange.class, "DataSetList", "attributes").get(0);
        List removedAttributesIds = setChangesDataSetListAttributes.getRemovedValues();
        InstanceId instanceId = (InstanceId)removedAttributesIds.get(0);
        UUID removedAttributeId = (UUID)instanceId.getCdoId();
        String attributeName = DeleteAttributeProcessor.getAttributeById(oldEntity, removedAttributeId).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.DELETED.toString());
        historyItem.setAttribute(attributeName);
        log.trace("Diff processed by DeleteAttributeChangeProcessor");
        return historyItem;
    }
}

