/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=12)
public class RenamedDataSetProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(RenamedDataSetProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ValueChange> dataSetNameChanges = RenamedDataSetProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, ValueChange.class, "DataSet", "name");
        return !dataSetNameChanges.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ValueChange dataSetNameChange = RenamedDataSetProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, ValueChange.class, "DataSet", "name").get(0);
        DataSetComparable dataset = (DataSetComparable)dataSetNameChange.getAffectedObject().get();
        String dataSetName = dataset.getName();
        String oldValue = RenamedDataSetProcessor.getDataSetById(oldEntity, dataset.getId()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.CHANGED.toString());
        historyItem.setDataSet(dataSetName);
        historyItem.setOldValue(oldValue);
        historyItem.setNewValue(dataSetName);
        log.trace("Diff processed by RenamedDataSetChangeProcessor");
        return historyItem;
    }
}

