/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.container.SetChange;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.AttributeComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=9)
public class UpdateListValuesProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(UpdateListValuesProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<SetChange> setChangesListValues = UpdateListValuesProcessor.filterChangesByTypeAndProperty(diff, SetChange.class, "listValues");
        List<SetChange> setChangesAttributes = UpdateListValuesProcessor.filterChangesByTypeAndProperty(diff, SetChange.class, "attributes");
        return !setChangesListValues.isEmpty() && setChangesAttributes.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        SetChange setChangeListValues = UpdateListValuesProcessor.filterChangesByTypeAndProperty(diff, SetChange.class, "listValues").get(0);
        AttributeComparable attribute = (AttributeComparable)setChangeListValues.getAffectedObject().get();
        String attributeName = attribute.getName();
        AttributeComparable oldAttribute = UpdateListValuesProcessor.getAttributeById(oldEntity, attribute.getId());
        String oldValue = UpdateListValuesProcessor.convertListValuesToString(oldAttribute);
        String newValue = UpdateListValuesProcessor.convertListValuesToString(attribute);
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.CHANGED.toString());
        historyItem.setAttribute(attributeName);
        historyItem.setOldValue(oldValue);
        historyItem.setNewValue(newValue);
        log.trace("Diff processed by ChangedListValuesChangeProcessor");
        return historyItem;
    }
}

