/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.utils;

import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;

public final class Split
extends AbstractBaseIterator<CharSequence> {
    private final CharSequence mValue;
    private final char mSeparator;
    private final int mLimit;
    private int mLastSeparatorPos = -1;
    private int mNextSeparatorPos = -1;
    private int mSplitCount;

    public Split(CharSequence value, char separator) {
        this(value, separator, Integer.MAX_VALUE);
    }

    public Split(CharSequence value, char separator, int maxSplits) {
        this.mValue = value;
        this.mSeparator = separator;
        this.mLimit = maxSplits;
    }

    public boolean hasNext() {
        if (this.mNextSeparatorPos == -1) {
            this.findNextSeparator();
        }
        return this.mLastSeparatorPos < this.mValue.length();
    }

    public CharSequence next() {
        if (this.mLastSeparatorPos >= this.mValue.length()) {
            throw new NoSuchElementException("Last element has already been iterated.");
        }
        if (this.mNextSeparatorPos == -1) {
            this.findNextSeparator();
        }
        CharSequence result = this.mValue.subSequence(this.mLastSeparatorPos + 1, this.mNextSeparatorPos);
        this.findNextSeparator();
        return result;
    }

    private void findNextSeparator() {
        this.mLastSeparatorPos = this.mNextSeparatorPos;
        if (this.mSplitCount >= this.mLimit) {
            this.mNextSeparatorPos = this.mValue.length();
            return;
        }
        while (++this.mNextSeparatorPos < this.mValue.length()) {
            char c = this.mValue.charAt(this.mNextSeparatorPos);
            if (c != this.mSeparator) continue;
            ++this.mSplitCount;
            return;
        }
    }
}

