/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.validation;

import org.dmfs.rfc3986.validation.CharSet;

public final class Validated
implements CharSequence {
    private final CharSequence mDelegate;
    private final CharSet mCharSet;
    private boolean mValidated;

    public Validated(CharSequence delegate, CharSet charSet) {
        this.mDelegate = delegate;
        this.mCharSet = charSet;
    }

    @Override
    public int length() {
        this.validate();
        return this.mDelegate.length();
    }

    @Override
    public char charAt(int i) {
        this.validate();
        return this.mDelegate.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        this.validate();
        return this.mDelegate.subSequence(i, i1);
    }

    @Override
    public String toString() {
        this.validate();
        return this.mDelegate.toString();
    }

    private void validate() {
        if (!this.mValidated) {
            CharSequence delegate = this.mDelegate;
            CharSet charSet = this.mCharSet;
            int count = delegate.length();
            for (int i = 0; i < count; ++i) {
                if (charSet.contains(delegate.charAt(i))) continue;
                throw new IllegalArgumentException(String.format("Illegal char '%c' at position %d in '%s'", Character.valueOf(delegate.charAt(i)), i, delegate.toString()));
            }
            this.mValidated = true;
        }
    }
}

