/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.visitors;

import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.iterators.ReferenceIterator;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import com.github.curiousoddman.rgxgen.iterators.suppliers.ArrayIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.ChoiceIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.GroupIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.IncrementalLengthIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.NegativeIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.PermutationsIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.ReferenceIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.SingleCaseInsensitiveValueIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.SingleValueIteratorSupplier;
import com.github.curiousoddman.rgxgen.nodes.Choice;
import com.github.curiousoddman.rgxgen.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.nodes.Group;
import com.github.curiousoddman.rgxgen.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.nodes.Repeat;
import com.github.curiousoddman.rgxgen.nodes.Sequence;
import com.github.curiousoddman.rgxgen.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class UniqueGenerationVisitor
implements NodeVisitor {
    private final List<Supplier<StringIterator>> aIterators = new ArrayList<Supplier<StringIterator>>();
    private final Map<Integer, List<ReferenceIterator>> aReferenceIteratorMap;
    private final Map<Integer, StringIterator> aGroupIterators;
    private final RgxGenProperties aProperties;

    public UniqueGenerationVisitor(RgxGenProperties properties) {
        this(new HashMap<Integer, List<ReferenceIterator>>(), new HashMap<Integer, StringIterator>(), properties);
    }

    public UniqueGenerationVisitor(Map<Integer, List<ReferenceIterator>> referenceIteratorMap, Map<Integer, StringIterator> groupIterators, RgxGenProperties properties) {
        this.aReferenceIteratorMap = referenceIteratorMap;
        this.aGroupIterators = groupIterators;
        this.aProperties = properties;
    }

    @Override
    public void visit(SymbolSet node) {
        if (RgxGenOption.CASE_INSENSITIVE.getBooleanFromProperties(this.aProperties)) {
            this.aIterators.add(new ArrayIteratorSupplier(node.getSymbolsCaseInsensitive()));
        } else {
            this.aIterators.add(new ArrayIteratorSupplier(node.getSymbols()));
        }
    }

    @Override
    public void visit(Choice node) {
        ArrayList<List<Supplier<StringIterator>>> nodeIterators = new ArrayList<List<Supplier<StringIterator>>>(node.getNodes().length);
        for (Node n : node.getNodes()) {
            UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
            n.visit(v);
            nodeIterators.add(v.aIterators);
        }
        this.aIterators.add(new ChoiceIteratorSupplier(nodeIterators));
    }

    @Override
    public void visit(FinalSymbol node) {
        if (RgxGenOption.CASE_INSENSITIVE.getBooleanFromProperties(this.aProperties)) {
            this.aIterators.add(new SingleCaseInsensitiveValueIteratorSupplier(node.getValue()));
        } else {
            this.aIterators.add(new SingleValueIteratorSupplier(node.getValue()));
        }
    }

    @Override
    public void visit(Repeat node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
        node.getNode().visit(v);
        this.aIterators.add(new IncrementalLengthIteratorSupplier(new PermutationsIteratorSupplier(v.aIterators), node.getMin(), node.getMax()));
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    @Override
    public void visit(NotSymbol node) {
        this.aIterators.add(new NegativeIteratorSupplier(node.getPattern(), new IncrementalLengthIteratorSupplier(new ArrayIteratorSupplier(SymbolSet.getAllSymbols()), 0, -1)));
    }

    @Override
    public void visit(GroupRef node) {
        this.aIterators.add(new ReferenceIteratorSupplier(this.aReferenceIteratorMap, this.aGroupIterators, node.getIndex()));
    }

    @Override
    public void visit(Group node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators, this.aProperties);
        node.getNode().visit(v);
        this.aIterators.add(new GroupIteratorSupplier(new PermutationsIteratorSupplier(v.aIterators), this.aReferenceIteratorMap, this.aGroupIterators, node.getIndex()));
    }

    public StringIterator getUniqueStrings() {
        return new PermutationsIteratorSupplier(this.aIterators).get();
    }
}

