/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsDiscoveryStrategy;
import com.hazelcast.aws.AwsProperties;
import com.hazelcast.aws.Environment;
import com.hazelcast.aws.RestClient;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AwsDiscoveryStrategyFactory
implements DiscoveryStrategyFactory {
    private static final ILogger LOGGER = Logger.getLogger(AwsDiscoveryStrategyFactory.class);

    @Override
    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return AwsDiscoveryStrategy.class;
    }

    @Override
    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        return new AwsDiscoveryStrategy(properties);
    }

    @Override
    public Collection<PropertyDefinition> getConfigurationProperties() {
        AwsProperties[] props = AwsProperties.values();
        ArrayList<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>(props.length);
        for (AwsProperties prop : props) {
            definitions.add(prop.getDefinition());
        }
        return definitions;
    }

    @Override
    public boolean isAutoDetectionApplicable() {
        return AwsDiscoveryStrategyFactory.isRunningOnEc2() && !AwsDiscoveryStrategyFactory.isRunningOnEcs();
    }

    private static boolean isRunningOnEc2() {
        return AwsDiscoveryStrategyFactory.uuidWithEc2Prefix() && AwsDiscoveryStrategyFactory.instanceIdentityExists() && AwsDiscoveryStrategyFactory.iamRoleAttached();
    }

    private static boolean uuidWithEc2Prefix() {
        String uuidPath = "/sys/hypervisor/uuid";
        if (new File(uuidPath).exists()) {
            String uuid = AwsDiscoveryStrategyFactory.readFileContents(uuidPath);
            return uuid.startsWith("ec2") || uuid.startsWith("EC2");
        }
        return false;
    }

    static String readFileContents(String fileName) {
        String string;
        FileInputStream is = null;
        try {
            File file = new File(fileName);
            byte[] data = new byte[(int)file.length()];
            is = new FileInputStream(file);
            ((InputStream)is).read(data);
            string = new String(data, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not get " + fileName, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource(is);
        return string;
    }

    private static boolean instanceIdentityExists() {
        return AwsDiscoveryStrategyFactory.isEndpointAvailable("http://169.254.169.254/latest/dynamic/instance-identity/");
    }

    private static boolean iamRoleAttached() {
        try {
            return AwsDiscoveryStrategyFactory.isEndpointAvailable("http://169.254.169.254/latest/meta-data/iam/security-credentials/");
        }
        catch (Exception e) {
            LOGGER.warning("Hazelcast running on EC2 instance, but no IAM Role attached. Cannot use Hazelcast AWS discovery.");
            LOGGER.finest(e);
            return false;
        }
    }

    static boolean isEndpointAvailable(String url) {
        return !RestClient.create(url).withConnectTimeoutSeconds(1).withReadTimeoutSeconds(1).withRetries(1).get().isEmpty();
    }

    private static boolean isRunningOnEcs() {
        return new Environment().isRunningOnEcs();
    }

    @Override
    public DiscoveryStrategyFactory.DiscoveryStrategyLevel discoveryStrategyLevel() {
        return DiscoveryStrategyFactory.DiscoveryStrategyLevel.CLOUD_VM;
    }
}

