/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.Index;
import org.polyjdbc.core.schema.model.Schema;

public final class IndexBuilder {
    private Index index;
    private Schema schema;

    private IndexBuilder(Dialect dialect, String name) {
        this.index = new Index(dialect, name);
    }

    private IndexBuilder(Schema schema, String name) {
        this(schema.getDialect(), name);
        this.schema = schema;
    }

    private IndexBuilder(Dialect dialect, String name, String schemaName) {
        this.index = new Index(dialect, name, schemaName);
    }

    private IndexBuilder(Schema schema, String name, String schemaName) {
        this(schema.getDialect(), name, schemaName);
        this.schema = schema;
    }

    public static IndexBuilder index(Dialect dialect, String name) {
        return new IndexBuilder(dialect, name);
    }

    public static IndexBuilder index(Schema schema, String name) {
        return new IndexBuilder(schema, name);
    }

    public static IndexBuilder index(Dialect dialect, String name, String schemaName) {
        return new IndexBuilder(dialect, name, schemaName);
    }

    public static IndexBuilder index(Schema schema, String name, String schemaName) {
        return new IndexBuilder(schema, name, schemaName);
    }

    public Index build() {
        if (this.schema != null) {
            this.schema.add(this.index);
        }
        return this.index;
    }

    public IndexBuilder on(String relation) {
        this.index.withTargetRelation(relation);
        return this;
    }

    public IndexBuilder indexing(String ... attributes) {
        this.index.withTargetAttributes(attributes);
        return this;
    }
}

