/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.flag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.ei.ntt.flag.Option;

public class Flag
implements Serializable {
    public static final String REMOTE = "Remote execution";
    public static final String SKIP_IF_ANY_PREV_EXCEPTION = "Skip if an exception has occurred in any previous item";
    public static final String STOP_ON_EXCEPTION = "Stop if an exception has occurred";
    public static final String STORE_RESULT_TO_CONTEXT = "Store result to context";
    public static final String SKIP_IF_STORED_FAIL = "Skip if the stored result was 'Failed' or 'Skipped'";
    public static final String STOP_IF_EXCEPTION_ON_ITEM = "Stop if an exception has occurred on this item";
    public static final String WARN_IF_FAIL = "Warn if fail";
    public static final String NEED_TO_REMOVE = "Need to remove this after complete";
    private static List<String> customFlags = Collections.synchronizedList(new ArrayList());
    private String name;
    private Map<String, Option<?>> options = new HashMap();
    private boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomFlag(String flag) {
        List<String> list = customFlags;
        synchronized (list) {
            if (!customFlags.contains(flag)) {
                customFlags.add(flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCustomFlags() {
        List<String> list = customFlags;
        synchronized (list) {
            return customFlags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCustomFlag(String flag) {
        List<String> list = customFlags;
        synchronized (list) {
            if (customFlags.contains(flag)) {
                customFlags.remove(flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCustomFlags() {
        List<String> list = customFlags;
        synchronized (list) {
            customFlags.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFlagsScope() {
        ArrayList<String> allFlags = new ArrayList<String>(Arrays.asList(REMOTE, SKIP_IF_ANY_PREV_EXCEPTION, STOP_IF_EXCEPTION_ON_ITEM, STOP_ON_EXCEPTION, STORE_RESULT_TO_CONTEXT, SKIP_IF_STORED_FAIL));
        List<String> list = customFlags;
        synchronized (list) {
            allFlags.addAll(customFlags);
        }
        return allFlags;
    }

    public Flag(String name) {
        this.name = name;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean hasOption(String option) {
        return this.options.containsKey(option);
    }

    public <T> T getOptionValue(String option) {
        if (this.hasOption(option)) {
            return this.getOption(option).getValue();
        }
        return null;
    }

    public <T> Option<T> getOption(String option) {
        return this.options.get(option);
    }

    public <T> void setOptionValue(String option, T value) {
        if (this.hasOption(option)) {
            this.getOption(option).setValue(value);
        } else {
            Option<T> optionO = new Option<T>(option, value);
            this.options.put(option, optionO);
        }
    }

    public String getName() {
        return this.name;
    }

    public Option<?>[] getOptions() {
        Option[] arr = new Option[this.options.size()];
        return this.options.values().toArray(arr);
    }

    public String toString() {
        if (this.options.isEmpty()) {
            return this.name;
        }
        return String.format("%s %s", this.name, Arrays.toString(this.getOptions()));
    }
}

