/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.log4j.Logger;
import org.qubership.atp.ei.ntt.settings.model.ApacheConfig;
import org.qubership.atp.ei.ntt.settings.model.ApacheXMLConfigurationProperties;
import org.qubership.atp.ei.ntt.settings.model.dal.support.DaoFactory;
import org.qubership.atp.ei.ntt.settings.store.file.apache.ApacheOptionProcessor;

public class ApacheXMLConfig
extends ApacheXMLConfigurationProperties
implements ApacheConfig {
    private static Logger log = Logger.getLogger(ApacheXMLConfig.class);
    private String filePath;
    private DaoFactory.XmlResource resource;
    private ApacheOptionProcessor processor = new ApacheOptionProcessor();
    protected static Map<Class<?>, ConvertSupport<?>> convertRule = new HashMap();

    public ApacheXMLConfig(DaoFactory.XmlResource resource) {
        this.resource = resource;
        super.setRootElementName(resource.getRootElementName());
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
        super.setFileName(filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public boolean read() {
        try {
            super.clear();
            super.load(new File(this.filePath));
            this.fireEvent(5, super.getRootNode().getName(), super.getRootNode(), false);
            return true;
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean write() {
        try {
            super.save(new File(this.filePath).getAbsolutePath());
            return true;
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean writeAs(String filePath) {
        try {
            super.save(filePath);
            return true;
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
            return false;
        }
    }

    public String getValue(SubnodeConfiguration node, String key) {
        return (String)node.getProperty(key);
    }

    @Override
    public void initAssociations(DaoFactory.ElementDal obj) {
        this.processor.load(obj, (HierarchicalConfiguration)this);
    }

    @Override
    public void setAssociations(DaoFactory.ElementDal obj) {
        this.processor.save(obj, this);
    }

    private static void initConvertRule() {
        convertRule.put(String.class, new ConvertSupport<String>(){

            @Override
            public String convert(String configValue) {
                return configValue;
            }
        });
        convertRule.put(Integer.TYPE, new ConvertSupport<Integer>(){

            @Override
            public Integer convert(String configValue) {
                return Integer.parseInt(configValue);
            }
        });
        convertRule.put(Integer.class, new ConvertSupport<Integer>(){

            @Override
            public Integer convert(String configValue) {
                return Integer.valueOf(configValue);
            }
        });
        convertRule.put(Boolean.TYPE, new ConvertSupport<Boolean>(){

            @Override
            public Boolean convert(String configValue) {
                return Boolean.parseBoolean(configValue);
            }
        });
        convertRule.put(Boolean.class, new ConvertSupport<Boolean>(){

            @Override
            public Boolean convert(String configValue) {
                return Boolean.valueOf(configValue);
            }
        });
    }

    private static <T> T convertType(Class<T> type, String value) {
        if (convertRule.size() == 0) {
            ApacheXMLConfig.initConvertRule();
        }
        return (T)convertRule.get(type).convert(value);
    }

    private static String convertType(Object value) {
        return value != null ? value.toString() : null;
    }

    public static interface ConvertSupport<T> {
        public T convert(String var1);
    }
}

