/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.store.file.apache;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.qubership.atp.ei.ntt.settings.model.AdditionalOption;
import org.qubership.atp.ei.ntt.settings.model.Option;
import org.qubership.atp.ei.ntt.settings.model.Options;
import org.qubership.atp.ei.ntt.settings.store.option.AbstractOptionProcessor;
import org.qubership.atp.ei.ntt.settings.store.option.OptionProcessException;

public class ApacheOptionProcessor
extends AbstractOptionProcessor<HierarchicalConfiguration> {
    private static final List<Class<?>> primitives = Lists.newArrayList((Object[])new Class[]{String.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Long.TYPE, Long.class});
    private Logger log = Logger.getLogger(ApacheOptionProcessor.class);

    @Override
    public Object loadOption(Field field, HierarchicalConfiguration source) throws OptionProcessException {
        String key = field.getAnnotation(Option.class).key();
        Class<?> type = field.getType();
        return this.getProperty(type, key, source);
    }

    private Object getProperty(Class type, String key, HierarchicalConfiguration source) throws OptionProcessException {
        String shortCanonicalName = ClassUtils.getShortCanonicalName((Class)type);
        try {
            Method method = source.getClass().getMethod(String.format("get%s", StringUtils.capitalize((String)shortCanonicalName)), String.class);
            return method.invoke((Object)source, key);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new OptionProcessException(e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e);
        }
    }

    public Object loadUnclassifiedParameters(Field field, HierarchicalConfiguration source) throws OptionProcessException {
        String additionalKey = field.getAnnotation(AdditionalOption.class).key();
        Class<String> type = String.class;
        Iterator keys = source.getKeys(additionalKey);
        HashMap<String, String> unclassMap = new HashMap<String, String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            unclassMap.put(key, (String)this.getProperty(type, key, source));
        }
        return unclassMap;
    }

    @Override
    public Object loadOptions(Field field, HierarchicalConfiguration source) throws OptionProcessException {
        String key = field.getAnnotation(Options.class).key();
        Type fieldGenericType = field.getGenericType();
        if (fieldGenericType instanceof ParameterizedType) {
            Class fieldClass = (Class)((ParameterizedType)fieldGenericType).getRawType();
            Type fieldTypeParameter = ((ParameterizedType)fieldGenericType).getActualTypeArguments()[0];
            if (Collection.class.isAssignableFrom(fieldClass)) {
                ArrayList values = Lists.newArrayListWithCapacity((int)(source.getMaxIndex(key) + 5));
                Class collectionClass = fieldTypeParameter instanceof ParameterizedType ? (Class)((ParameterizedType)fieldTypeParameter).getRawType() : (Class)fieldTypeParameter;
                for (int i = 0; i < source.getMaxIndex(key) + 1; ++i) {
                    String newKey = String.format("%s(%s)", key, i);
                    SubnodeConfiguration configuration = source.configurationAt(newKey);
                    if (primitives.contains(collectionClass)) {
                        values.add(this.getProperty(collectionClass, newKey, source));
                        continue;
                    }
                    try {
                        values.add(this.load(collectionClass.newInstance(), (HierarchicalConfiguration)configuration));
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new OptionProcessException(e);
                    }
                }
                return values;
            }
            throw new OptionProcessException(String.format("Unsupported raw type: %s", fieldClass));
        }
        throw new OptionProcessException(String.format("Unknown field type: %s", fieldGenericType));
    }

    @Override
    public <Y> Y load(Y object, HierarchicalConfiguration source) {
        Class<?> daoClass = object.getClass();
        while (!daoClass.getSuperclass().equals(Object.class)) {
            for (Field field : daoClass.getDeclaredFields()) {
                Object value;
                if (field.getAnnotation(Option.class) != null) {
                    value = null;
                    try {
                        value = this.loadOption(field, source);
                        this.setFieldValue(object, field, value);
                    }
                    catch (OptionProcessException e) {
                        this.log.warn((Object)"Error loading option", (Throwable)e);
                    }
                    continue;
                }
                if (field.getAnnotation(Options.class) != null) {
                    value = null;
                    try {
                        value = this.loadOptions(field, source);
                        this.setFieldValue(object, field, value);
                    }
                    catch (OptionProcessException e) {
                        this.log.warn((Object)"Error loading option", (Throwable)e);
                    }
                    continue;
                }
                if (field.getAnnotation(AdditionalOption.class) == null) continue;
                value = null;
                try {
                    value = this.loadUnclassifiedParameters(field, source);
                    this.setFieldValue(object, field, value);
                }
                catch (OptionProcessException e) {
                    this.log.warn((Object)"Error loading option", (Throwable)e);
                }
            }
            daoClass = daoClass.getSuperclass();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFieldValue(Object object, Field field, Object value) {
        Object val = value;
        try {
            field.setAccessible(true);
            if (value != null) {
                val = field.getType().getSimpleName().equals("String") ? ((String)value).trim() : value;
            }
            field.set(object, val);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    @Override
    public void saveOption(Object object, Field field, HierarchicalConfiguration source) {
        this.setProperty(field.getAnnotation(Option.class).key(), this.getFieldValue(object, field), source);
    }

    private void setProperty(String key, Object value, HierarchicalConfiguration source) {
        source.setProperty(key, value);
    }

    private void generateTreeByKey(String key, HierarchicalConfiguration configuration) {
        ConfigurationNode rootNode = configuration.getRootNode();
        Iterable split = Splitter.on((char)'.').split((CharSequence)key);
        for (String nodeName : split) {
            int index = 0;
            Matcher matcher = Pattern.compile("\\((\\d+)\\)").matcher(nodeName);
            if (matcher.find()) {
                index = Integer.parseInt(matcher.group(1));
            }
            if (rootNode.getChildren(nodeName).size() <= index) {
                rootNode.addChild((ConfigurationNode)new HierarchicalConfiguration.Node(nodeName.replaceAll("\\(\\d+\\)", "")));
            }
            rootNode = (ConfigurationNode)rootNode.getChildren(nodeName.replaceAll("\\(\\d+\\)", "")).get(index);
        }
    }

    @Override
    protected void iterate(String key, HierarchicalConfiguration source, List<?> toIterate, Class<?> collectionClass) {
        for (int i = 0; i < toIterate.size(); ++i) {
            if (source.getMaxIndex(key) < i) {
                if (key.lastIndexOf(46) > 0) {
                    source.addNodes(key.substring(0, key.lastIndexOf(46)), (Collection)Lists.newArrayList((Object[])new HierarchicalConfiguration.Node[]{new HierarchicalConfiguration.Node(key.substring(key.lastIndexOf(46) + 1))}));
                } else {
                    source.getRootNode().addChild((ConfigurationNode)new HierarchicalConfiguration.Node(key));
                }
            }
            String newKey = String.format("%s(%s)", key, i);
            try {
                SubnodeConfiguration configuration = source.configurationAt(newKey);
                if (primitives.contains(collectionClass)) {
                    this.setProperty(newKey, toIterate.get(i), source);
                    continue;
                }
                this.save(toIterate.get(i), configuration);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"", (Throwable)e);
            }
        }
        while (source.getMaxIndex(key) >= toIterate.size()) {
            String newKey = String.format("%s(%s)", key, source.getMaxIndex(key));
            ConfigurationNode rootNode = source.configurationAt(newKey).getRootNode();
            this.cyclicRemoveNode(source.getRootNode(), rootNode);
        }
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    private void cyclicRemoveNode(ConfigurationNode root, ConfigurationNode toRemove) {
        if (root.getChildren().contains(toRemove)) {
            root.removeChild(toRemove);
        } else {
            for (ConfigurationNode configurationNode : root.getChildren()) {
                this.cyclicRemoveNode(configurationNode, toRemove);
            }
        }
    }
}

