/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.threetenbp.DecimalUtils;
import com.fasterxml.jackson.datatype.threetenbp.deser.ThreeTenDeserializerBase;
import com.fasterxml.jackson.datatype.threetenbp.function.BiFunction;
import java.io.IOException;
import java.math.BigDecimal;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Duration;

public class DurationDeserializer
extends ThreeTenDeserializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();

    private DurationDeserializer() {
        super(Duration.class);
    }

    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                BigDecimal value = parser.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(value, new BiFunction<Long, Integer, Duration>(){

                    @Override
                    public Duration apply(Long seconds, Integer nanoAdjustment) {
                        return Duration.ofSeconds((long)seconds, (long)nanoAdjustment.intValue());
                    }
                });
            }
            case 7: {
                if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return Duration.ofSeconds((long)parser.getLongValue());
                }
                return Duration.ofMillis((long)parser.getLongValue());
            }
            case 6: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                try {
                    return Duration.parse((CharSequence)string);
                }
                catch (DateTimeException e) {
                    return (Duration)this._handleDateTimeException(context, e, string);
                }
            }
            case 12: {
                return (Duration)parser.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(parser, context);
            }
        }
        return (Duration)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }
}

