/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.threetenbp.DecimalUtils;
import com.fasterxml.jackson.datatype.threetenbp.deser.ThreeTenDateTimeDeserializerBase;
import com.fasterxml.jackson.datatype.threetenbp.function.BiFunction;
import com.fasterxml.jackson.datatype.threetenbp.function.Function;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;

public class InstantDeserializer<T extends Temporal>
extends ThreeTenDateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    private static final Pattern ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX = Pattern.compile("\\+00:?(00)?$");
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, new Function<TemporalAccessor, Instant>(){

        @Override
        public Instant apply(TemporalAccessor temporalAccessor) {
            return Instant.from((TemporalAccessor)temporalAccessor);
        }
    }, new Function<FromIntegerArguments, Instant>(){

        @Override
        public Instant apply(FromIntegerArguments a) {
            return Instant.ofEpochMilli((long)a.value);
        }
    }, new Function<FromDecimalArguments, Instant>(){

        @Override
        public Instant apply(FromDecimalArguments a) {
            return Instant.ofEpochSecond((long)a.integer, (long)a.fraction);
        }
    }, null, true);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, new Function<TemporalAccessor, OffsetDateTime>(){

        @Override
        public OffsetDateTime apply(TemporalAccessor temporalAccessor) {
            return OffsetDateTime.from((TemporalAccessor)temporalAccessor);
        }
    }, new Function<FromIntegerArguments, OffsetDateTime>(){

        @Override
        public OffsetDateTime apply(FromIntegerArguments a) {
            return OffsetDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)a.value), (ZoneId)a.zoneId);
        }
    }, new Function<FromDecimalArguments, OffsetDateTime>(){

        @Override
        public OffsetDateTime apply(FromDecimalArguments a) {
            return OffsetDateTime.ofInstant((Instant)Instant.ofEpochSecond((long)a.integer, (long)a.fraction), (ZoneId)a.zoneId);
        }
    }, new BiFunction<OffsetDateTime, ZoneId, OffsetDateTime>(){

        @Override
        public OffsetDateTime apply(OffsetDateTime d, ZoneId z) {
            return d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime()));
        }
    }, true);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, new Function<TemporalAccessor, ZonedDateTime>(){

        @Override
        public ZonedDateTime apply(TemporalAccessor temporalAccessor) {
            return ZonedDateTime.from((TemporalAccessor)temporalAccessor);
        }
    }, new Function<FromIntegerArguments, ZonedDateTime>(){

        @Override
        public ZonedDateTime apply(FromIntegerArguments a) {
            return ZonedDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)a.value), (ZoneId)a.zoneId);
        }
    }, new Function<FromDecimalArguments, ZonedDateTime>(){

        @Override
        public ZonedDateTime apply(FromDecimalArguments a) {
            return ZonedDateTime.ofInstant((Instant)Instant.ofEpochSecond((long)a.integer, (long)a.fraction), (ZoneId)a.zoneId);
        }
    }, new BiFunction<ZonedDateTime, ZoneId, ZonedDateTime>(){

        @Override
        public ZonedDateTime apply(ZonedDateTime zonedDateTime, ZoneId zoneId) {
            return zonedDateTime.withZoneSameInstant(zoneId);
        }
    }, false);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replaceZeroOffsetAsZ;
    protected final Boolean _adjustToContextTZOverride;

    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust, boolean replaceZeroOffsetAsZ) {
        super(supportedType, formatter);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? new BiFunction<T, ZoneId, T>(){

            @Override
            public T apply(T d, ZoneId z) {
                return d;
            }
        } : adjust;
        this.replaceZeroOffsetAsZ = replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = null;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, DateTimeFormatter f) {
        super(base.handledType(), f);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base._adjustToContextTZOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, Boolean adjustToContextTimezoneOverride) {
        super(base.handledType(), base._formatter);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = base.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = adjustToContextTimezoneOverride;
    }

    @Override
    protected InstantDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dtf);
    }

    @Override
    protected InstantDeserializer<T> withLeniency(Boolean leniency) {
        return this;
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                return this._fromDecimal(context, parser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(context, parser.getLongValue());
            }
            case 6: {
                Temporal value;
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                if (this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
                    int dots = this._countPeriods(string);
                    if (dots >= 0) {
                        try {
                            if (dots == 0) {
                                return this._fromLong(context, Long.parseLong(string));
                            }
                            if (dots == 1) {
                                return this._fromDecimal(context, new BigDecimal(string));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    string = this.replaceZeroOffsetAsZIfNecessary(string);
                }
                try {
                    TemporalAccessor acc = this._formatter.parse((CharSequence)string);
                    value = (Temporal)this.parsedToValue.apply(acc);
                    if (this.shouldAdjustToContextTimezone(context)) {
                        return (T)((Temporal)this.adjust.apply(value, this.getZone(context)));
                    }
                }
                catch (DateTimeException e) {
                    value = (Temporal)this._handleDateTimeException(context, e, string);
                }
                return (T)value;
            }
            case 12: {
                return (T)((Temporal)parser.getEmbeddedObject());
            }
            case 3: {
                return (T)((Temporal)this._deserializeFromArray(parser, context));
            }
        }
        return (T)((Temporal)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT));
    }

    @Override
    public JsonDeserializer<T> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value val;
        InstantDeserializer deserializer = (InstantDeserializer)super.createContextual(ctxt, property);
        if (deserializer != this && (val = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            return new InstantDeserializer<T>(deserializer, val.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE));
        }
        return this;
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext context) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : context.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected int _countPeriods(String str) {
        int commas = 0;
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                ++commas;
                continue;
            }
            return -1;
        }
        return commas;
    }

    protected T _fromLong(DeserializationContext context, long timestamp) {
        if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(timestamp, 0, this.getZone(context))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(timestamp, this.getZone(context))));
    }

    protected T _fromDecimal(final DeserializationContext context, BigDecimal value) {
        FromDecimalArguments args = DecimalUtils.extractSecondsAndNanos(value, new BiFunction<Long, Integer, FromDecimalArguments>(){

            @Override
            public FromDecimalArguments apply(Long s, Integer ns) {
                return new FromDecimalArguments(s, ns, InstantDeserializer.this.getZone(context));
            }
        });
        return (T)((Temporal)this.fromNanoseconds.apply(args));
    }

    private ZoneId getZone(DeserializationContext context) {
        return this._valueClass == Instant.class ? null : DateTimeUtils.toZoneId((TimeZone)context.getTimeZone());
    }

    private String replaceZeroOffsetAsZIfNecessary(String text) {
        if (this.replaceZeroOffsetAsZ) {
            return ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX.matcher(text).replaceFirst("Z");
        }
        return text;
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        private FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        private FromIntegerArguments(long value, ZoneId zoneId) {
            this.value = value;
            this.zoneId = zoneId;
        }
    }
}

