/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Map;
import java.util.TreeMap;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.converters.models.Pageable;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.PageRequest;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, havingValue="true")
public class AtpSwaggerConfig {
    @Bean
    public OpenAPI openApiDefinition() {
        SpringDocUtils.getConfig().replaceParameterObjectWithClass(org.springframework.data.domain.Pageable.class, Pageable.class).replaceParameterObjectWithClass(PageRequest.class, Pageable.class).removeRequestWrapperToIgnore(new Class[]{Map.class});
        return new OpenAPI().addSecurityItem(new SecurityRequirement().addList("Bearer Authentication")).components(new Components().addSecuritySchemes("Bearer Authentication", this.createApiKeyScheme())).info(new Info().title("ATP-Datasets").license(new License().name("(C) Copyright Qubership Technology")));
    }

    @Bean
    public OpenApiCustomiser globalOperationOpenApiCustomiser() {
        return openAPI -> openAPI.getPaths().values().forEach(pathItem -> pathItem.readOperations().forEach(operation -> {
            if (!StringUtils.hasLength((String)operation.getSummary())) {
                operation.setSummary(operation.getOperationId().split("_")[0]);
            }
        }));
    }

    @Bean
    public OpenApiCustomiser sortSchemasAlphabetically() {
        return openApi -> {
            Map schemas = openApi.getComponents().getSchemas();
            openApi.getComponents().setSchemas(new TreeMap(schemas));
        };
    }

    private SecurityScheme createApiKeyScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).bearerFormat("JWT").scheme("bearer");
    }
}

