/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;

@Configuration
@ConditionalOnProperty(value={"kafka.enable"}, matchIfMissing=false)
@ComponentScan(value={"org.qubership.atp.dataset.kafka"})
public class KafkaConfiguration {
    public static final String KAFKA_PROJECT_EVENT_CONTAINER_FACTORY_NAME = "projectEventContainerFactory";
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String kafkaServer;

    @Bean(value={"projectEventContainerFactory"})
    public KafkaListenerContainerFactory<?> projectEventContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.projectEventConsumerFactory());
        factory.setErrorHandler((e, consumerRecord) -> {
            throw new RuntimeException("Error during event processing.", e);
        });
        return factory;
    }

    @Bean
    public ConsumerFactory projectEventConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs());
    }

    @Bean
    public Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaServer);
        props.put("key.deserializer", UUIDDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        return props;
    }
}

