/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import java.util.HashMap;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.qubership.atp.dataset.config.BeanAwareSpringLiquibase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LiquibaseProperties.class})
public class SpringLiquibaseConfig {
    private DataSource dataSource;
    private LiquibaseProperties properties;
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${service.entities.migration.enabled:false}")
    private String serviceEntitiesMigrationEnabled;

    public SpringLiquibaseConfig(DataSource dataSource, LiquibaseProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @Bean
    public SpringLiquibase liquibase() {
        BeanAwareSpringLiquibase liquibase = new BeanAwareSpringLiquibase();
        liquibase.setDataSource(this.dataSource);
        liquibase.setChangeLog(this.properties.getChangeLog());
        liquibase.setContexts(this.properties.getContexts());
        liquibase.setDefaultSchema(this.properties.getDefaultSchema());
        liquibase.setDropFirst(this.properties.isDropFirst());
        liquibase.setShouldRun(this.properties.isEnabled());
        liquibase.setLabels(this.properties.getLabels());
        HashMap<String, String> parameters = this.properties.getParameters();
        if (null == parameters) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("spring.application.name", this.serviceName);
        parameters.put("service.entities.migration.enabled", this.serviceEntitiesMigrationEnabled);
        liquibase.setChangeLogParameters(parameters);
        liquibase.setRollbackFile(this.properties.getRollbackFile());
        return liquibase;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public LiquibaseProperties getProperties() {
        return this.properties;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceEntitiesMigrationEnabled() {
        return this.serviceEntitiesMigrationEnabled;
    }
}

