/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.task.DelegatingSecurityContextAsyncTaskExecutor;

@Configuration
@EnableAsync
public class ThreadPoolConfig {
    private static final String THREAD_NAME_PREFIX = "ArchiveJob-";
    private static final String THREAD_NAME_ASYNC_COPY_PREFIX = "AsyncCopy-";
    @Value(value="${atp-dataset.archive.job.thread.max-pool-size}")
    private Integer maxPoolSize;
    @Value(value="${atp-dataset.archive.job.thread.core-pool-size}")
    private Integer corePoolSize;
    @Value(value="${atp-dataset.archive.job.thread.queue-capacity}")
    private Integer queueCapacity;

    @Bean
    public ThreadPoolTaskExecutor archiveJobExecutor() {
        return this.createExecutor(THREAD_NAME_PREFIX);
    }

    @Qualifier(value="asyncCopyTaskExecutor")
    @Bean(value={"asyncCopyTaskExecutor"})
    public AsyncTaskExecutor asyncCopyTaskExecutor() {
        return new DelegatingSecurityContextAsyncTaskExecutor((AsyncTaskExecutor)this.createExecutor(THREAD_NAME_ASYNC_COPY_PREFIX));
    }

    private ThreadPoolTaskExecutor createExecutor(String prefix) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadNamePrefix(prefix);
        executor.initialize();
        return executor;
    }
}

