/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config.interceptors;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.dataset.service.jpa.model.CacheCleanupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleCorsRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SimpleCorsRequestFilter.class);
    @Autowired
    protected CacheCleanupService cacheCleanupService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.loggingRequest(req);
        try {
            HttpServletResponse response = (HttpServletResponse)res;
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, PATCH, DELETE, COPY, HEAD, OPTIONS");
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Key, Authorization, Content-Disposition");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            HttpServletRequest request = (HttpServletRequest)req;
            if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
                response.setStatus(200);
            } else {
                chain.doFilter(req, res);
            }
        }
        finally {
            this.cacheCleanupService.cleanAllLocalThreadCache();
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void loggingRequest(ServletRequest req) {
        HttpServletRequest httpServletRequest = null;
        try {
            httpServletRequest = (HttpServletRequest)req;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (httpServletRequest != null && (httpServletRequest.getRequestURI().contains("/itf") || httpServletRequest.getRequestURI().contains("/atp"))) {
            String endpoint = httpServletRequest.getRequestURI();
            String message = "Request for DataSet  - Endpoint: \"" + endpoint + "\", Method: \"" + httpServletRequest.getMethod();
            log.info(message);
        }
    }
}

