/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.dataset.controllers.api.dto.datasets.CompareDsRequestDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.CompareDsResponseDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.CopyDsAttributeBulkRequestDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.CopyDsAttributeRequestDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.CopyDsAttributeResponseDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.DataSetTreeDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.DetailedComparisonDsRequestDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.DetailedComparisonDsResponseDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.LabelDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.ObjectShortResponseDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.PageAbstractEntityResponseDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.PairOfUUidAndIntDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.ParameterDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.TableResponseDto;
import org.qubership.atp.dataset.controllers.api.dto.datasets.UiManAttributeDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="DataSetController", description="Data Set Controller")
public interface DataSetControllerApi {
    @Operation(operationId="addLabel", summary="addLabel", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/ds/{dataSetId}/label"}, produces={"application/json"})
    public ResponseEntity<LabelDto> addLabel(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="compareDsAtp", summary="Compare Datasets from different test cases.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompareDsResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/compare"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CompareDsResponseDto> compareDsAtp(@Parameter(name="CompareDsRequestDto", description="", required=true) @Valid @RequestBody CompareDsRequestDto var1);

    @Operation(operationId="copy", summary="Copy DS with name provided.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/ds/{dataSetId}/copy"}, produces={"application/json"})
    public ResponseEntity<UUID> copy(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2);

    @Operation(operationId="copyDsAttributes", summary="Copy attribute from source dataset to target dataset.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CopyDsAttributeResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/compare/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CopyDsAttributeResponseDto> copyDsAttributes(@Parameter(name="CopyDsAttributeRequestDto", description="", required=true) @Valid @RequestBody CopyDsAttributeRequestDto var1);

    @Operation(operationId="copyDsAttributesBulk", summary="Copy all attributes from source dataset to target dataset.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/compare/copy/bulk"}, consumes={"application/json"})
    public ResponseEntity<Void> copyDsAttributesBulk(@Parameter(name="CopyDsAttributeBulkRequestDto", description="", required=true) @Valid @RequestBody CopyDsAttributeBulkRequestDto var1);

    @Operation(operationId="create", summary="Creates new DS with name provided.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/ds/{dataSetListId}/ds"}, produces={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3);

    @Operation(operationId="delete", summary="Deletes selected DS.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/ds/{dataSetId}"})
    public ResponseEntity<Void> delete(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3);

    @Operation(operationId="deleteLabel", summary="deleteLabel", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/ds/{dataSetId}/label/{labelId}"}, produces={"application/json"})
    public ResponseEntity<Boolean> deleteLabel(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="labelId", description="labelId", required=true) @PathVariable(value="labelId") UUID var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="detailedComparisonDsAtp", summary="Detailed datasets comparison.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DetailedComparisonDsResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/compare/detailed"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DetailedComparisonDsResponseDto> detailedComparisonDsAtp(@Parameter(name="DetailedComparisonDsRequestDto", description="", required=true) @Valid @RequestBody DetailedComparisonDsRequestDto var1);

    @Operation(operationId="getAffectedDataSets", summary="Returns all affected dataSets by specified reference with pagination support.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetId}/affectedDatasets"}, produces={"application/json"})
    public ResponseEntity<List<TableResponseDto>> getAffectedDataSets(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1);

    @Operation(operationId="getAffectedDataSetsByChangesDataSetReference", summary="Returns all affected dataSets by changes at reference value.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/dsReferenceId/affected/by"}, produces={"application/json"})
    public ResponseEntity<List<Object>> getAffectedDataSetsByChangesDataSetReference(@NotNull @Parameter(name="dsReferenceId", description="dsReferenceId", required=true) @Valid @RequestParam(value="dsReferenceId", required=true) UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) String var2);

    @Operation(operationId="getAffectedDataSetsCount", summary="Returns all affected dataSets count by specified reference.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=BigDecimal.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetId}/affectedDatasetsCount"}, produces={"application/json"})
    public ResponseEntity<BigDecimal> getAffectedDataSetsCount(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1);

    @Operation(operationId="getAtpContextFull", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetTreeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DataSetTreeDto> getAtpContextFull(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var3);

    @Operation(operationId="getAtpContextFullBulk", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Object>> getAtpContextFullBulk(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="countOfEvaluates", description="countOfEvaluates") @Valid @RequestParam(value="countOfEvaluates", required=false) Integer var3, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, String> var4);

    @Operation(operationId="getAtpContextObject", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetTreeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp/object"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DataSetTreeDto> getAtpContextObject(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var3);

    @Operation(operationId="getAtpContextObjectBulk", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp/object/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Object>> getAtpContextObjectBulk(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="countOfEvaluates", description="countOfEvaluates") @Valid @RequestParam(value="countOfEvaluates", required=false) Integer var3, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, String> var4);

    @Operation(operationId="getAtpContextObjectExtended", summary="Returns dataSet by id in ATP format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetTreeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp/objectExtended"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DataSetTreeDto> getAtpContextObjectExtended(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var3);

    @Operation(operationId="getAtpContextOptimized", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetTreeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp/optimized"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DataSetTreeDto> getAtpContextOptimized(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var3);

    @Operation(operationId="getAtpContextOptimizedBulk", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/atp/optimized/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Object>> getAtpContextOptimizedBulk(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="countOfEvaluates", description="countOfEvaluates") @Valid @RequestParam(value="countOfEvaluates", required=false) Integer var3, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, String> var4);

    @Operation(operationId="getDataSetById", summary="Returns dataSet by id.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetId}"}, produces={"application/json"})
    public ResponseEntity<Object> getDataSetById(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1);

    @Operation(operationId="getDataSets", summary="Returns all dataSets.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds"}, produces={"application/json"})
    public ResponseEntity<List<Object>> getDataSets();

    @Operation(operationId="getDataSetsByIds", summary="Returns dataSets by id-s.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/listOfDatasets"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Object>> getDataSetsByIds(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="getDataSetsByName", summary="Returns all dataSets.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageAbstractEntityResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/find-name-pagination"}, produces={"application/json"})
    public ResponseEntity<PageAbstractEntityResponseDto> getDataSetsByName(@NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var1, @NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var2, @Parameter(name="offset", description="") @Valid @RequestParam(value="offset", required=false) Long var3, @Parameter(name="pageNumber", description="") @Valid @RequestParam(value="pageNumber", required=false) Integer var4, @Parameter(name="pageSize", description="") @Valid @RequestParam(value="pageSize", required=false) Integer var5, @Parameter(name="paged", description="") @Valid @RequestParam(value="paged", required=false) Boolean var6, @Parameter(name="sort.sorted", description="") @Valid @RequestParam(value="sort.sorted", required=false) Boolean var7, @Parameter(name="sort.unsorted", description="") @Valid @RequestParam(value="sort.unsorted", required=false) Boolean var8, @Parameter(name="unpaged", description="") @Valid @RequestParam(value="unpaged", required=false) Boolean var9);

    @Operation(operationId="getDataSetsForAtp", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/legacy/atp"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> getDataSetsForAtp(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") String var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="body", description="") @Valid @RequestBody(required=false) String var3);

    @Operation(operationId="getDataSetsShort", summary="Returns list of Datasets (id + name) for selected DSL.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectShortResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetListId}/short"}, produces={"application/json"})
    public ResponseEntity<List<ObjectShortResponseDto>> getDataSetsShort(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getDatasetsOrTableResponseAffectedByChangeParameterValue", summary="Returns all affected datasets by changes at attribute.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/affected/by"}, produces={"application/json"})
    public ResponseEntity<List<Object>> getDatasetsOrTableResponseAffectedByChangeParameterValue(@NotNull @Parameter(name="dataSetId", description="dataSetId", required=true) @Valid @RequestParam(value="dataSetId", required=true) UUID var1, @NotNull @Parameter(name="attributeId", description="attributeId", required=true) @Valid @RequestParam(value="attributeId", required=true) UUID var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) String var3);

    @Operation(operationId="getInItfFormat", summary="Returns dataSet by id in ITF format: {attribute = parameter, attribute2 : {attribute = parameter2}}.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetId}/legacy/itf"}, produces={"application/json"})
    public ResponseEntity<Object> getInItfFormat(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") String var1);

    @Operation(operationId="getItfContext", summary="Returns dataSet by id in ITF format + atp macros", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetId}/itf"}, produces={"application/json"})
    public ResponseEntity<String> getItfContext(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1);

    @Operation(operationId="getLabels", summary="getLabels", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/{dataSetId}/label"}, produces={"application/json"})
    public ResponseEntity<List<LabelDto>> getLabels(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1);

    @Operation(operationId="getPath", summary="returns visibility area and data set list ids", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PairOfUUidAndIntDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/ds/parent/path"}, produces={"application/json"})
    public ResponseEntity<PairOfUUidAndIntDto> getPath(@NotNull @Parameter(name="dsId", description="dsId", required=true) @Valid @RequestParam(value="dsId", required=true) UUID var1);

    @Operation(operationId="getUiAttribute", summary="getUiAttribute", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UiManAttributeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/parameters"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UiManAttributeDto> getUiAttribute(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="evaluate", description="evaluate") @Valid @RequestParam(value="evaluate", required=false) String var2, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var3);

    @Operation(operationId="lock", summary="Lock DS from change.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/lock/update"}, consumes={"application/json"})
    public ResponseEntity<Void> lock(@NotNull @Parameter(name="dataSetListId", description="dataSetListId", required=true) @Valid @RequestParam(value="dataSetListId", required=true) UUID var1, @NotNull @Parameter(name="locked", description="locked ds flag", required=true) @Valid @RequestParam(value="locked", required=true) Boolean var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var4);

    @Operation(operationId="rename", summary="Renames DS.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}"})
    public ResponseEntity<Void> rename(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="resetOverriddenParameter", summary="Reset all selected datasets, at changed attribute. dataSetIds is ids of datasets in which we want to reset overridden parameters with attributeId provided", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ParameterDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/reset/by"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ParameterDto> resetOverriddenParameter(@NotNull @Parameter(name="dataSetId", description="dataSetId", required=true) @Valid @RequestParam(value="dataSetId", required=true) UUID var1, @NotNull @Parameter(name="targetAttrId", description="targetAttrId", required=true) @Valid @RequestParam(value="targetAttrId", required=true) UUID var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var5);

    @Operation(operationId="restAffectedDatasetsByChangesAttribute", summary="Reset all selected datasets, at changed attribute", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/reset/affected/by"}, consumes={"application/json"})
    public ResponseEntity<Void> restAffectedDatasetsByChangesAttribute(@Parameter(name="attributeId", description="attributeId") @Valid @RequestParam(value="attributeId", required=false) UUID var1, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var2, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var3, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var4);

    @Operation(operationId="restore", summary="restore", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/restore"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Boolean> restore(@Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var1, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var2, @Parameter(name="body", description="") @Valid @RequestBody(required=false) Object var3);

    @Operation(operationId="setPosition", summary="Creates new list values for provided attribute by text.", tags={"data-set-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/ds/{dataSetId}/position"}, consumes={"application/json"})
    public ResponseEntity<Void> setPosition(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) Integer var2);
}

