/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.dataset.controllers.api.dto.parameters.ParameterDto;
import org.qubership.atp.dataset.controllers.api.dto.parameters.TableResponseDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ParameterController", description="Parameter Controller")
public interface ParameterControllerApi {
    @Operation(operationId="bulkUpdateAttribute", summary="Bulk update value of parameters.", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="226", description="IM Used"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/parameter/bulk/attribute/{attributeId}"}, produces={"application/json"})
    public ResponseEntity<List<Object>> bulkUpdateAttribute(@Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var1, @NotNull @Parameter(name="dataSetListId", description="dataSetListId", required=true) @Valid @RequestParam(value="dataSetListId", required=true) UUID var2, @Parameter(name="value", description="value") @Valid @RequestParam(value="value", required=false) String var3, @Parameter(name="file", description="file") @Valid @RequestParam(value="file", required=false) Resource var4, @Parameter(name="dataSetsIds", description="dataSetsIds") @Valid @RequestParam(value="dataSetsIds", required=false) List<UUID> var5, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var6, @Parameter(name="attrPathIds", description="attrPathIds") @Valid @RequestParam(value="attrPathIds", required=false) List<UUID> var7);

    @Operation(operationId="create", summary="Creates new parameter with provided text.", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/parameter/ds/{dataSetId}/attribute/{attributeId}"}, produces={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var2, @Parameter(name="value", description="value") @Valid @RequestParam(value="value", required=false) String var3, @Parameter(name="dataSetReference", description="dataSetReference") @Valid @RequestParam(value="dataSetReference", required=false) UUID var4, @Parameter(name="listValueReference", description="listValueReference") @Valid @RequestParam(value="listValueReference", required=false) UUID var5, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var6, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var7);

    @Operation(operationId="delete", summary="Deletes value of the selected parameter.", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/parameter"})
    public ResponseEntity<Void> delete(@NotNull @Parameter(name="dataSetId", description="dataSetId", required=true) @Valid @RequestParam(value="dataSetId", required=true) UUID var1, @NotNull @Parameter(name="attributeId", description="attributeId", required=true) @Valid @RequestParam(value="attributeId", required=true) UUID var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4);

    @Operation(operationId="getAffectedParametersByListValue", summary="Get all parameters which uses provided ListValue", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/parameter/affected/by/"}, produces={"application/json"})
    public ResponseEntity<List<Object>> getAffectedParametersByListValue(@Parameter(name="listValueId", description="listValueId") @Valid @RequestParam(value="listValueId", required=false) UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) String var2);

    @Operation(operationId="getAffectedParametersByListValues", summary="Get all parameters which use provided ListValue", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/parameter/affected/by/listValues"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TableResponseDto>> getAffectedParametersByListValues(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="getDataSetParameters", summary="Returns the parameters of selected DS.", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ParameterDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/parameter/ds/{dataSetId}"}, produces={"application/json"})
    public ResponseEntity<List<ParameterDto>> getDataSetParameters(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1);

    @Operation(operationId="getOriginalParameter", summary="getOriginalParameter", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ParameterDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/parameter/get/original"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ParameterDto> getOriginalParameter(@NotNull @Parameter(name="dataSetId", description="dataSetId", required=true) @Valid @RequestParam(value="dataSetId", required=true) UUID var1, @NotNull @Parameter(name="targetAttrId", description="targetAttrId", required=true) @Valid @RequestParam(value="targetAttrId", required=true) UUID var2, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var3, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var4, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var5);

    @Operation(operationId="update", summary="Updates value of the selected parameter.", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ParameterDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/parameter/ds/{dataSetId}/attribute/{attributeId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ParameterDto> update(@Parameter(name="dataSetId", description="dataSetId", required=true) @PathVariable(value="dataSetId") UUID var1, @Parameter(name="attributeId", description="attributeId", required=true) @PathVariable(value="attributeId") UUID var2, @Parameter(name="value", description="value") @Valid @RequestParam(value="value", required=false) String var3, @Parameter(name="dataSetReference", description="dataSetReference") @Valid @RequestParam(value="dataSetReference", required=false) UUID var4, @Parameter(name="listValueReference", description="listValueReference") @Valid @RequestParam(value="listValueReference", required=false) UUID var5, @Parameter(name="dataSetListId", description="dataSetListId") @Valid @RequestParam(value="dataSetListId", required=false) UUID var6, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var7, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var8);

    @Operation(operationId="updateParameters", summary="Updates value of the selected parameters. Please do not use for files or overlaps!", tags={"parameter-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/parameter/update/bulk"}, consumes={"application/json"})
    public ResponseEntity<Void> updateParameters(@NotNull @Parameter(name="dataSetListId", description="dataSetListId", required=true) @Valid @RequestParam(value="dataSetListId", required=true) UUID var1, @Parameter(name="value", description="value") @Valid @RequestParam(value="value", required=false) String var2, @Parameter(name="dataSetReference", description="dataSetReference") @Valid @RequestParam(value="dataSetReference", required=false) UUID var3, @Parameter(name="listValueReference", description="listValueReference") @Valid @RequestParam(value="listValueReference", required=false) UUID var4, @Parameter(name="modifiedWhen", description="modifiedWhen") @Valid @RequestParam(value="modifiedWhen", required=false) Long var5, @Parameter(name="dataSetId", description="dataSetId") @Valid @RequestParam(value="dataSetId", required=false) UUID var6, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var7);
}

