/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.ListValueRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.generated.QAttribute;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.ListValueImpl;
import org.qubership.atp.dataset.service.ws.entities.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AttributeRepository
extends AbstractRepository {
    private static final QAttribute ATTR_ALIAS;
    private static final Expression<?>[] COLUMNS;
    protected final SQLQueryFactory queryFactory;
    private final Provider<DataSetListRepository> dslRepo;
    private final Provider<ParameterRepository> paramRepo;
    private final Provider<ListValueRepository> lvRepo;
    private final CacheRepository cacheRepo;
    private final AttributeProjection attrProjection;

    @Autowired
    public AttributeRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull Provider<DataSetListRepository> dslRepo, @Nonnull Provider<ParameterRepository> paramRepo, @Nonnull Provider<ListValueRepository> lvRepo, @Nonnull CacheRepository cacheRepo) {
        this.queryFactory = queryFactory;
        this.dslRepo = dslRepo;
        this.paramRepo = paramRepo;
        this.lvRepo = lvRepo;
        this.cacheRepo = cacheRepo;
        this.attrProjection = new AttributeProjection(this);
    }

    @Nonnull
    public Attribute create(@Nonnull UUID dslId, @Nonnull Integer order, @Nonnull String name, @Nonnull AttributeType type, @Nullable UUID dslRefId, @Nullable List<String> listValues) {
        SQLInsertClause insert = (SQLInsertClause)this.queryFactory.insert((RelationalPath)ATTR).set(AttributeRepository.ATTR.ordering, (Object)order);
        if (dslRefId != null) {
            Preconditions.checkArgument((type == AttributeType.DSL || type == AttributeType.CHANGE ? 1 : 0) != 0, (String)"It is not possible to set DSL reference [%s] to attribute with type [%s]", (Object)dslRefId, (Object)((Object)type));
            insert.set(AttributeRepository.ATTR.typeDatasetlistId, (Object)dslRefId);
        }
        ((SQLInsertClause)((SQLInsertClause)insert.set((Path)AttributeRepository.ATTR.name, (Object)name)).set(AttributeRepository.ATTR.datasetlistId, (Object)dslId)).set(AttributeRepository.ATTR.attributeTypeId, (Object)type.getId());
        UUID id = (UUID)Preconditions.checkNotNull((Object)((UUID)insert.executeWithKey(AttributeRepository.ATTR.id)), (Object)"nothing created");
        List<ListValue> listValueObjs = null;
        if (listValues != null && !listValues.isEmpty()) {
            listValueObjs = ((ListValueRepository)this.lvRepo.get()).create(id, listValues);
        }
        return this.attrProjection.create(id, name, dslId, type, dslRefId, null, listValueObjs);
    }

    public boolean updateTypeDslId(@Nonnull UUID dslId, UUID id) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ATTR).where((Predicate)AttributeRepository.ATTR.typeDatasetlistId.eq((Object)dslId))).set(AttributeRepository.ATTR.typeDatasetlistId, (Object)id)).execute() > 0L;
    }

    public boolean update(@Nonnull UUID id, @Nonnull String name) {
        return this.update((Predicate)AttributeRepository.ATTR.id.eq((Object)id), name) > 0L;
    }

    protected long update(@Nonnull Predicate predicate, @Nonnull String name) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ATTR).where(predicate)).set((Path)AttributeRepository.ATTR.name, (Object)name)).execute();
    }

    public boolean updateDslRef(@Nonnull UUID id, @Nonnull UUID dataSetListId) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ATTR).where((Predicate)AttributeRepository.ATTR.id.eq((Object)id).and((Predicate)AttributeRepository.ATTR.attributeTypeId.eq((Object)AttributeType.DSL.getId())))).set(AttributeRepository.ATTR.typeDatasetlistId, (Object)dataSetListId)).execute() > 0L;
    }

    @Nullable
    public Attribute getById(@Nonnull UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(Attribute.class, id, uuid -> (Attribute)this.select((Predicate)AttributeRepository.ATTR.id.eq(uuid)).fetchOne());
    }

    public boolean existsById(@Nonnull UUID id) {
        return this.cacheRepo.getIfPresent(Attribute.class, id) != null || this.select((Predicate)AttributeRepository.ATTR.id.eq((Object)id)).fetchCount() > 0L;
    }

    @Nonnull
    public List<Attribute> getByParentId(@Nonnull UUID dslId) {
        return ((SQLQuery)this.select((Predicate)AttributeRepository.ATTR.datasetlistId.eq((Object)dslId)).orderBy(AttributeRepository.ATTR.ordering.asc())).fetch();
    }

    @Nonnull
    public List<Attribute> getByParentId(@Nonnull UUID dslId, @Nonnull AttributeType type) {
        return ((SQLQuery)this.select((Predicate)AttributeRepository.ATTR.datasetlistId.eq((Object)dslId).and((Predicate)AttributeRepository.ATTR.attributeTypeId.eq((Object)type.getId()))).orderBy(AttributeRepository.ATTR.ordering.asc())).fetch();
    }

    @Nonnull
    public Collection<Attribute> getEagerByParentId(@Nonnull UUID dslId) {
        SQLQuery<Tuple> sqlQuery = this.getQuerySelectFromAttributeByDslIdJoinParameterAndJoinListValue(dslId);
        Map<UUID, Attribute> attributes = this.getAttributes(dslId, sqlQuery);
        return attributes.values();
    }

    private SQLQuery<Tuple> getQuerySelectFromAttributeByDslIdJoinParameterAndJoinListValue(@Nonnull UUID dslId) {
        return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(COLUMNS).from(ExpressionUtils.as((Expression)((Expression)((SQLQuery)SQLExpressions.select((Expression[])ATTR.all()).from((Expression)ATTR)).where((Predicate)AttributeRepository.ATTR.datasetlistId.eq((Object)dslId))), (String)"attr"))).leftJoin((EntityPath)PARAM)).on((Predicate)AttributeRepository.PARAM.attributeId.eq(AttributeRepository.ATTR_ALIAS.id))).leftJoin((EntityPath)LV)).on((Predicate)AttributeRepository.LV.attributeId.eq(AttributeRepository.ATTR_ALIAS.id))).orderBy(new OrderSpecifier[]{AttributeRepository.ATTR_ALIAS.ordering.asc(), AttributeRepository.LV.text.asc()});
    }

    private Map<UUID, Attribute> getAttributes(@Nonnull UUID dslId, SQLQuery<Tuple> attr) {
        LinkedHashMap<UUID, Attribute> attributes = new LinkedHashMap<UUID, Attribute>();
        HashMap<UUID, ListValue> listValues = new HashMap<UUID, ListValue>();
        HashMap<UUID, Parameter> parameters = new HashMap<UUID, Parameter>();
        try (CloseableIterator iter = attr.iterate();){
            while (iter.hasNext()) {
                Tuple row = (Tuple)iter.next();
                UUID id = (UUID)row.get(AttributeRepository.ATTR_ALIAS.id);
                String name = (String)row.get((Expression)AttributeRepository.ATTR_ALIAS.name);
                Short attrTypeId = (Short)row.get(AttributeRepository.ATTR_ALIAS.attributeTypeId);
                AttributeType type = AttributeType.from(attrTypeId);
                UUID typeDslId = (UUID)row.get(AttributeRepository.ATTR_ALIAS.typeDatasetlistId);
                UUID lvId = (UUID)row.get(AttributeRepository.LV.id);
                String lvText = (String)row.get((Expression)AttributeRepository.LV.text);
                UUID paramId = (UUID)row.get(AttributeRepository.PARAM.id);
                Attribute attribute = attributes.computeIfAbsent(id, key -> {
                    DataSetList dslRef = null;
                    if (typeDslId != null) {
                        dslRef = Proxies.withId(DataSetList.class, typeDslId, uuid -> ((DataSetListRepository)this.dslRepo.get()).getById((UUID)uuid));
                    }
                    DataSetList dsl = Proxies.withId(DataSetList.class, dslId, uuid -> ((DataSetListRepository)this.dslRepo.get()).getById((UUID)uuid));
                    return new AttributeImpl(id, name, dsl, type, dslRef, new ArrayList<ListValue>(), new ArrayList<Parameter>());
                });
                this.fillListValues(lvId, listValues, lvText, attribute);
                this.fillParameters(paramId, parameters, attribute);
            }
        }
        return attributes;
    }

    private void fillListValues(UUID lvId, Map<UUID, ListValue> listValues, String lvText, Attribute attribute) {
        if (lvId != null) {
            listValues.computeIfAbsent(lvId, key -> {
                assert (lvText != null);
                ListValueImpl result = new ListValueImpl(lvId, attribute, lvText);
                attribute.getListValues().add(result);
                return result;
            });
        }
    }

    private void fillParameters(UUID paramId, Map<UUID, Parameter> parameters, Attribute attribute) {
        if (paramId != null) {
            parameters.computeIfAbsent(paramId, key -> {
                Parameter result = Proxies.withId(Parameter.class, paramId, uuid -> ((ParameterRepository)this.paramRepo.get()).getById((UUID)uuid));
                attribute.getParameters().add(result);
                return result;
            });
        }
    }

    @Nonnull
    public List<Attribute> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.attrProjection).from((Expression)ATTR)).fetch();
    }

    @Nonnull
    protected SQLQuery<Attribute> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.attrProjection).from((Expression)ATTR)).where(predicate);
    }

    void onDslDeleteCascade(UUID dslId) {
        this.getByParentId(dslId).forEach(attr -> this.delete(attr.getId()));
        ((SQLQuery)((SQLQuery)this.queryFactory.select(AttributeRepository.ATTR.id).from((Expression)ATTR)).where((Predicate)AttributeRepository.ATTR.typeDatasetlistId.eq((Object)dslId))).fetch().forEach(this::delete);
    }

    public boolean delete(@Nonnull UUID id) {
        ((ParameterRepository)this.paramRepo.get()).onAttrDeleteCascade(id);
        ((ListValueRepository)this.lvRepo.get()).onAttrDeleteCascade(id);
        return this.delete((Predicate)AttributeRepository.ATTR.id.eq((Object)id)) > 0L;
    }

    private long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)ATTR).where(predicate)).execute();
    }

    public void updateOrdering(List<Pair<UUID, Integer>> attributesOrdering) {
        for (Pair<UUID, Integer> attrToUpdate : attributesOrdering) {
            ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ATTR).set(AttributeRepository.ATTR.ordering, (Object)attrToUpdate.getSecond())).where((Predicate)AttributeRepository.ATTR.id.eq((Object)UUID.fromString(((Object)attrToUpdate.getFirst()).toString())))).execute();
        }
    }

    static {
        QAttribute attributeAlias = new QAttribute("attr");
        ImmutableList expressions = ImmutableList.builder().addAll(Arrays.asList(attributeAlias.all())).add(AttributeRepository.PARAM.id).add(AttributeRepository.LV.id).add((Object)AttributeRepository.LV.text).build();
        COLUMNS = (Expression[])expressions.toArray((Object[])new Expression[0]);
        ATTR_ALIAS = attributeAlias;
    }

    private static class AttributeProjection
    extends MappingProjection<Attribute> {
        private final AttributeRepository repo;

        AttributeProjection(@Nonnull AttributeRepository repo) {
            super(Attribute.class, new Expression[]{AbstractRepository.ATTR.id, AbstractRepository.ATTR.name, AbstractRepository.ATTR.datasetlistId, AbstractRepository.ATTR.attributeTypeId, AbstractRepository.ATTR.typeDatasetlistId});
            this.repo = repo;
        }

        protected AttributeImpl map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.ATTR.id);
            assert (id != null);
            String name = (String)row.get((Expression)AbstractRepository.ATTR.name);
            assert (name != null);
            UUID dslId = (UUID)row.get(AbstractRepository.ATTR.datasetlistId);
            assert (dslId != null);
            Short attrTypeId = (Short)row.get(AbstractRepository.ATTR.attributeTypeId);
            assert (attrTypeId != null);
            AttributeType type = AttributeType.from(attrTypeId);
            UUID typeDslId = (UUID)row.get(AbstractRepository.ATTR.typeDatasetlistId);
            return this.create(id, name, dslId, type, typeDslId, null, null);
        }

        public AttributeImpl create(@Nonnull UUID id, @Nonnull String name, @Nonnull UUID dslId, @Nonnull AttributeType type, @Nullable UUID typeDslId, @Nullable List<Parameter> parameters, @Nullable List<ListValue> listValues) {
            DataSetList dslRef = null;
            if (typeDslId != null) {
                dslRef = Proxies.withId(DataSetList.class, typeDslId, uuid -> ((DataSetListRepository)this.repo.dslRepo.get()).getById((UUID)uuid));
            }
            if (parameters == null) {
                parameters = Proxies.list(() -> ((ParameterRepository)this.repo.paramRepo.get()).getByAttributeId(id));
            }
            if (listValues == null) {
                listValues = Proxies.list(() -> ((ListValueRepository)this.repo.lvRepo.get()).getByAttributeId(id));
            }
            DataSetList dsl = Proxies.withId(DataSetList.class, dslId, uuid -> ((DataSetListRepository)this.repo.dslRepo.get()).getById((UUID)uuid));
            return new AttributeImpl(id, name, dsl, type, dslRef, listValues, parameters);
        }
    }
}

