/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.Union;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.AttributePathRepository;
import org.qubership.atp.dataset.db.AttributeRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.IdentifiedCache;
import org.qubership.atp.dataset.db.LabelRepository;
import org.qubership.atp.dataset.db.ListValueRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.TestPlanRepository;
import org.qubership.atp.dataset.db.VisibilityAreaRepository;
import org.qubership.atp.dataset.db.dto.AttributePathDto;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.db.utils.StrongIdentifiedCache;
import org.qubership.atp.dataset.exception.attribute.AttributeTypeException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributePath;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.AttributePathImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.ParameterBaseImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.model.impl.ParameterOverlapImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class DataSetListTreeRepository
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final Provider<DataSetListRepository> dslRepo;
    private final Provider<DataSetRepository> dsRepo;
    private final Provider<AttributeRepository> attrRepo;
    private final Provider<ParameterRepository> paramRepo;
    private final Provider<GridFsRepository> gridFsRepoProvider;
    private final Provider<LabelRepository> labelRepo;
    private final Provider<VisibilityAreaRepository> vaRepo;
    private final Provider<TestPlanRepository> testPlanRepo;
    private final Provider<ListValueRepository> lvRepo;
    private final CacheRepository cacheRepo;
    private final Expression<String> typeSafeNullString;
    private final Expression<UUID> typeSafeNullUuid;
    private final QDslDs dslDs;
    private final QDslDs.QDslAttr dslAttr;
    private final QDslDs.QDslAttrPath dslAttrPath;

    @Autowired
    public DataSetListTreeRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull Provider<VisibilityAreaRepository> vaRepo, @Nonnull Provider<TestPlanRepository> testPlanRepo, @Nonnull Provider<DataSetListRepository> dslRepo, @Nonnull Provider<DataSetRepository> dsRepo, @Nonnull Provider<AttributeRepository> attrRepo, @Nonnull Provider<ParameterRepository> paramRepo, @Nonnull Provider<GridFsRepository> gridFsRepoProvider, @Nonnull Provider<LabelRepository> labelRepo, @Nonnull Provider<ListValueRepository> lvRepo, @Nonnull CacheRepository cacheRepo, @Nonnull Configuration configuration) {
        this.queryFactory = queryFactory;
        this.vaRepo = vaRepo;
        this.testPlanRepo = testPlanRepo;
        this.dsRepo = dsRepo;
        this.attrRepo = attrRepo;
        this.labelRepo = labelRepo;
        this.cacheRepo = cacheRepo;
        this.typeSafeNullString = Expressions.template(String.class, (String)("null::" + configuration.getTypeNameForCast(String.class)), (Object[])new Object[0]);
        this.dslRepo = dslRepo;
        this.typeSafeNullUuid = Expressions.template(UUID.class, (String)"null::uuid", (Object[])new Object[0]);
        this.lvRepo = lvRepo;
        this.paramRepo = paramRepo;
        this.gridFsRepoProvider = gridFsRepoProvider;
        this.dslDs = new QDslDs("dsl_ds");
        this.dslAttr = this.dslDs.createAttrs("dsl_attr");
        this.dslAttrPath = this.dslDs.createAttrPath("dsl_ak");
    }

    @Nullable
    public DataSetList getEagerById(@Nonnull UUID id, @Nullable Collection<UUID> dataSetsFilter, @Nullable Collection<UUID> attributesFilter, Integer startIndex, Integer endIndex, boolean isSortEnabled) {
        DataSetList result = this.cacheRepo.getIfPresent(DataSetList.class, id);
        if (result != null) {
            return result;
        }
        IdentifiedCache cache = dataSetsFilter == null || attributesFilter == null ? this.cacheRepo.getCache() : new StrongIdentifiedCache();
        return this.getDslTree(id, dataSetsFilter, attributesFilter, new ToLoadLater(this, cache), startIndex, endIndex, isSortEnabled);
    }

    protected DataSetList getDslTree(@Nonnull UUID id, @Nonnull ToLoadLater loadLater) {
        return this.getDslTree(id, null, null, loadLater, null, null, false);
    }

    protected DataSetList getDslTree(@Nonnull UUID id, @Nullable Collection<UUID> dataSetsFilter, @Nonnull ToLoadLater loadLater) {
        return this.getDslTree(id, dataSetsFilter, null, loadLater, null, null, false);
    }

    @Nullable
    protected DataSetList getDslTree(@Nonnull UUID id, @Nullable Collection<UUID> dataSetsFilter, @Nullable Collection<UUID> attributesFilter, @Nonnull ToLoadLater loadLater, Integer startIndex, Integer endIndex, boolean isSortEnabled) {
        Union<Tuple> tupleUnion = this.createUnion(id, dataSetsFilter, attributesFilter, startIndex, endIndex);
        DataSetList dsl = null;
        try (CloseableIterator iter = tupleUnion.iterate();){
            while (iter.hasNext()) {
                Tuple next = (Tuple)iter.next();
                UUID vaId = (UUID)next.get((Expression)this.dslAttrPath.vaId);
                UUID dslId = (UUID)next.get((Expression)this.dslAttrPath.dslId);
                UUID testPlanId = (UUID)next.get((Expression)this.dslAttrPath.testPlanId);
                String dslName = (String)next.get((Expression)this.dslAttrPath.dslName);
                assert (vaId != null);
                assert (dslId != null);
                UUID createdBy = (UUID)next.get((Expression)this.dslAttrPath.createdBy);
                Timestamp createdWhen = (Timestamp)next.get((Expression)this.dslAttrPath.createdWhen);
                UUID modifiedBy = (UUID)next.get((Expression)this.dslAttrPath.modifiedBy);
                Timestamp modifiedWhen = (Timestamp)next.get((Expression)this.dslAttrPath.modifiedWhen);
                dsl = this.createDsl(vaId, dslId, dslName, loadLater, testPlanId, createdBy, createdWhen, modifiedBy, modifiedWhen);
                UUID dsId = (UUID)next.get((Expression)this.dslAttrPath.dsId);
                String dsName = (String)next.get((Expression)this.dslAttrPath.dsName);
                Boolean dsLocked = (Boolean)next.get((Expression)this.dslAttrPath.dsLocked);
                DataSet dataSet = null;
                if (dsId != null) {
                    dataSet = this.createDs(dsl, dsId, dsName, dsLocked, loadLater);
                }
                UUID attrId = (UUID)next.get((Expression)this.dslAttrPath.attrId);
                String attrName = (String)next.get((Expression)this.dslAttrPath.attrName);
                Short attrTypeId = (Short)next.get((Expression)this.dslAttrPath.attrType);
                UUID attrDslRef = (UUID)next.get((Expression)this.dslAttrPath.attrDslRef);
                String attrKey = (String)next.get((Expression)this.dslAttrPath.attrKey);
                Attribute attribute2 = null;
                AttributePath attrPath = null;
                if (attrId == null) continue;
                assert (attrTypeId != null);
                AttributeType attrType = AttributeType.from(attrTypeId);
                List<ListValue> listValues = Proxies.list(() -> ((ListValueRepository)this.lvRepo.get()).getByAttributeId(attrId));
                if (attrKey == null) {
                    attribute2 = this.createAttr(dsl, attrId, attrName, attrType, attrDslRef, listValues, loadLater);
                } else {
                    assert (dataSet != null);
                    UUID targetAttrDslId = (UUID)next.get((Expression)this.dslAttrPath.targetAttrDslId);
                    assert (targetAttrDslId != null);
                    UUID targetAttrId = (UUID)next.get((Expression)this.dslAttrPath.targetAttrId);
                    assert (targetAttrId != null);
                    attrPath = this.createAttrPath(attrId, dslId, dataSet, targetAttrId, attrKey, targetAttrDslId, loadLater);
                }
                UUID paramId = (UUID)next.get((Expression)this.dslAttrPath.paramId);
                String string = (String)next.get((Expression)this.dslAttrPath.string);
                UUID list = (UUID)next.get((Expression)this.dslAttrPath.list);
                UUID ds = (UUID)next.get((Expression)this.dslAttrPath.ds);
                if (paramId == null) continue;
                assert (dataSet != null);
                this.createParameter(attrPath, attribute2, attrType, paramId, dataSet, string, list, attrDslRef, ds, loadLater);
            }
        }
        if (isSortEnabled) {
            assert (dsl != null);
            Comparator<Attribute> comparator = Comparator.comparing(attribute -> !AttributeType.DSL.equals((Object)attribute.getType()));
            comparator = comparator.thenComparing(Named::getName);
            dsl.setAttributes(dsl.getAttributes().stream().sorted(comparator).collect(Collectors.toList()));
        }
        return dsl;
    }

    private Union<Tuple> createUnion(UUID id, Collection<UUID> dataSetsFilter, Collection<UUID> attributesFilter, Integer startIndex, Integer endIndex) {
        return startIndex != null && endIndex != null && endIndex > startIndex ? ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.query().with((Path)this.dslDs, (SubQueryExpression)((SQLQuery)this.dslDs.getQuery(id, dataSetsFilter).offset((long)startIndex.intValue())).limit((long)(endIndex - startIndex + 1)))).with((Path)this.dslAttr, this.dslAttr.getQuery(attributesFilter))).with((Path)this.dslAttrPath, this.dslAttrPath.getQuery())).union((List)ImmutableList.of((Object)this.queryFactory.select(this.dslAttrPath.all()).from((Expression)this.dslAttrPath), (Object)this.queryFactory.select(this.dslAttr.all()).from((Expression)this.dslAttr))).orderBy(new OrderSpecifier[]{this.dslAttrPath.dsOrder.asc(), this.dslAttrPath.attrOrder.asc()}) : ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.query().with((Path)this.dslDs, this.dslDs.getQuery(id, dataSetsFilter))).with((Path)this.dslAttr, this.dslAttr.getQuery(attributesFilter))).with((Path)this.dslAttrPath, this.dslAttrPath.getQuery())).union((List)ImmutableList.of((Object)this.queryFactory.select(this.dslAttrPath.all()).from((Expression)this.dslAttrPath), (Object)this.queryFactory.select(this.dslAttr.all()).from((Expression)this.dslAttr))).orderBy(new OrderSpecifier[]{this.dslAttrPath.dsOrder.asc(), this.dslAttrPath.attrOrder.asc()});
    }

    @Nonnull
    private DataSetList createDsl(@Nonnull UUID vaId, @Nonnull UUID dslId, String dslName, @Nonnull IdentifiedCache cache, @Nullable UUID testPlanId, UUID createdBy, Timestamp createdWhen, UUID modifiedBy, Timestamp modifiedWhen) {
        return cache.computeIfAbsent(DataSetList.class, dslId, dataSetListId -> {
            VisibilityArea va = Proxies.withId(VisibilityArea.class, vaId, uuid -> ((VisibilityAreaRepository)this.vaRepo.get()).getById((UUID)uuid));
            List<Label> labels = Proxies.list(() -> ((LabelRepository)this.labelRepo.get()).getLabelsOfDsl((UUID)dataSetListId));
            TestPlan testPlan = null;
            if (testPlanId != null) {
                testPlan = Proxies.withId(TestPlan.class, testPlanId, uuid -> ((TestPlanRepository)this.testPlanRepo.get()).getById((UUID)uuid));
            }
            return new DataSetListImpl((UUID)dataSetListId, va, dslName, (List<DataSet>)new ArrayList<DataSet>(), (List<Attribute>)new ArrayList<Attribute>(), labels, testPlan, createdBy, createdWhen, modifiedBy, modifiedWhen);
        });
    }

    private DataSet createDs(@Nonnull DataSetList dsl, @Nonnull UUID dsId, String dsName, Boolean dsLocked, @Nonnull IdentifiedCache cache) {
        return cache.computeIfAbsent(DataSet.class, dsId, dataSetId -> {
            List<Label> labels = Proxies.list(() -> ((LabelRepository)this.labelRepo.get()).getLabelsOfDs((UUID)dataSetId));
            DataSetImpl result = new DataSetImpl((UUID)dataSetId, dsName, dsl, (List<Parameter>)new ArrayList<Parameter>(), labels, dsLocked);
            dsl.getDataSets().add(result);
            return result;
        });
    }

    private Attribute createAttr(@Nonnull DataSetList dataSetList, @Nonnull UUID attrId, String attrName, @Nonnull AttributeType attrType, @Nullable UUID dslRef, @Nonnull List<ListValue> listValues, @Nonnull ToLoadLater toLoadLater) {
        return toLoadLater.computeIfAbsent(Attribute.class, attrId, attributeId -> {
            DataSetList dslReference = null;
            if (AttributeType.DSL == attrType && dslRef != null) {
                dslReference = toLoadLater.provideDslRef(dslRef);
            }
            AttributeImpl result = new AttributeImpl((UUID)attributeId, attrName, dataSetList, attrType, dslReference, listValues, (List<Parameter>)new ArrayList<Parameter>());
            dataSetList.getAttributes().add(result);
            return result;
        });
    }

    @Nonnull
    private Parameter createParameter(@Nullable AttributePath attrPath, @Nullable Attribute attribute, @Nonnull AttributeType type, @Nonnull UUID paramId, @Nonnull DataSet dataSet, @Nullable String string, @Nullable UUID list, @Nullable UUID dslRef, @Nullable UUID ds, @Nonnull ToLoadLater loadLater) {
        return loadLater.computeIfAbsent(Parameter.class, paramId, uuid -> {
            ParameterBaseImpl parameter;
            if (attrPath == null) {
                assert (attribute != null);
                parameter = new ParameterImpl();
                parameter.setAttribute(attribute);
                attribute.getParameters().add(parameter);
            } else {
                ParameterOverlapImpl overlap = new ParameterOverlapImpl();
                overlap.setAttributePath(attrPath);
                parameter = overlap;
            }
            parameter.setId(paramId);
            parameter.setDataSet(dataSet);
            switch (type) {
                case CHANGE: 
                case ENCRYPTED: 
                case TEXT: {
                    parameter.setText(string);
                    break;
                }
                case FILE: {
                    ((GridFsRepository)this.gridFsRepoProvider.get()).getFileInfo(paramId).ifPresent(parameter::setFileData);
                    break;
                }
                case LIST: {
                    parameter.setListValue(list == null ? null : ((ListValueRepository)this.lvRepo.get()).getById(list));
                    break;
                }
                case DSL: {
                    if (dslRef == null || ds == null) break;
                    parameter.setDataSetReference(loadLater.provideDsRef(dslRef, ds));
                    break;
                }
                default: {
                    throw new AttributeTypeException(attribute.getName(), attribute.getType().toString());
                }
            }
            dataSet.getParameters().add(parameter);
            return parameter;
        });
    }

    private AttributePath createAttrPath(@Nonnull UUID attrId, @Nonnull UUID dslId, @Nonnull DataSet dataSet, @Nonnull UUID targetAttrId, @Nonnull String attrKey, @Nonnull UUID targetAttrDslId, @Nonnull ToLoadLater loadLater) {
        AttributePathDto attrPathDto = AttributePathRepository.AttributePathProjection.createDto(attrId, dslId, dataSet.getId(), targetAttrId, attrKey);
        Attribute targetAttribute = loadLater.provideAttr(targetAttrDslId, targetAttrId);
        List<Attribute> attrList = attrPathDto.getAttributePathIds().stream().map(uuid -> Proxies.withId(Attribute.class, uuid, attributeId -> ((AttributeRepository)this.attrRepo.get()).getById((UUID)attributeId))).collect(Collectors.toList());
        return new AttributePathImpl(attrPathDto.getId(), dataSet, targetAttribute, attrList);
    }

    class QDslDs
    extends TemporaryPathBase<QDslDs> {
        SimplePath<UUID> dslId;
        SimplePath<UUID> vaId;
        StringPath dslName;
        SimplePath<UUID> testPlanId;
        SimplePath<UUID> createdBy;
        DateTimePath<Timestamp> createdWhen;
        SimplePath<UUID> modifiedBy;
        DateTimePath<Timestamp> modifiedWhen;
        SimplePath<UUID> dsId;
        StringPath dsName;
        NumberPath<Long> dsOrder;
        BooleanPath dsLocked;

        QDslDs(String variable) {
            super(QDslDs.class, variable);
        }

        @Override
        protected void init() {
            this.dslId = this.delegateSimple("dsl_id", AbstractRepository.DSL.id);
            this.vaId = this.delegateSimple("va_id", AbstractRepository.DSL.visibilityAreaId);
            this.dslName = this.delegateString("dsl_name", AbstractRepository.DSL.name);
            this.testPlanId = this.delegateSimple("test_plan_id", AbstractRepository.DSL.testPlanId);
            this.createdBy = this.delegateSimple("created_by", AbstractRepository.DSL.createdBy);
            this.createdWhen = this.delegateDateTime("created_when", AbstractRepository.DSL.createdWhen);
            this.modifiedBy = this.delegateSimple("modified_by", AbstractRepository.DSL.modifiedBy);
            this.modifiedWhen = this.delegateDateTime("modified_when", AbstractRepository.DSL.modifiedWhen);
            this.dsId = this.delegateSimple("ds_id", AbstractRepository.DS.id);
            this.dsName = this.delegateString("ds_name", AbstractRepository.DS.name);
            this.dsOrder = this.delegateNumber("ds_order", AbstractRepository.DS.ordering);
            this.dsLocked = this.delegateBoolean("ds_locked", AbstractRepository.DS.locked);
        }

        QDslAttr createAttrs(String alias) {
            return new QDslAttr(alias);
        }

        QDslAttrPath createAttrPath(String alias) {
            return new QDslAttrPath(alias);
        }

        SQLQuery<List<?>> getQuery(@Nonnull UUID id, @Nullable Collection<UUID> dataSetsFilter) {
            BooleanExpression predicate = AbstractRepository.DS.datasetlistId.eq(AbstractRepository.DSL.id);
            if (dataSetsFilter != null && !dataSetsFilter.isEmpty()) {
                predicate = predicate.and((Predicate)AbstractRepository.DS.id.in(dataSetsFilter));
            }
            return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)DataSetListTreeRepository.this.queryFactory.select(this.bindings()).from((Expression)AbstractRepository.DSL)).leftJoin((EntityPath)AbstractRepository.DS)).on((Predicate)predicate)).where((Predicate)AbstractRepository.DSL.id.eq((Object)id))).orderBy(AbstractRepository.DS.ordering.asc());
        }

        class QDslAttr
        extends AbstractQDslAttr<QDslAttr> {
            private QDslAttr(String variable) {
                super(QDslAttr.class, variable);
            }

            @Override
            @Nullable
            protected SimplePath<UUID> getAttrId() {
                return AbstractRepository.ATTR.id;
            }

            @Override
            @Nullable
            protected StringPath getAttrKey() {
                return null;
            }

            @Override
            @Nullable
            protected SimplePath<UUID> getTargetAttrId() {
                return null;
            }

            @Override
            @Nullable
            protected SimplePath<UUID> getTargetAttrDslId() {
                return null;
            }

            SQLQuery<List<?>> getQuery(@Nullable Collection<UUID> attributesFilter) {
                SQLQuery query = (SQLQuery)DataSetListTreeRepository.this.queryFactory.select(this.bindings()).from((Expression)QDslDs.this);
                if (!CollectionUtils.isEmpty(attributesFilter)) {
                    ((SQLQuery)query.leftJoin((EntityPath)AbstractRepository.ATTR)).on((Predicate)AbstractRepository.ATTR.datasetlistId.eq(QDslDs.this.dslId).and((Predicate)AbstractRepository.ATTR.id.in(attributesFilter)));
                } else {
                    ((SQLQuery)query.leftJoin((EntityPath)AbstractRepository.ATTR)).on((Predicate)AbstractRepository.ATTR.datasetlistId.eq(QDslDs.this.dslId));
                }
                ((SQLQuery)query.leftJoin((EntityPath)AbstractRepository.PARAM)).on((Predicate)AbstractRepository.PARAM.attributeId.eq(AbstractRepository.ATTR.id).and((Predicate)AbstractRepository.PARAM.datasetId.eq(QDslDs.this.dsId)));
                return query;
            }
        }

        class QDslAttrPath
        extends AbstractQDslAttr<QDslAttrPath> {
            private QDslAttrPath(String variable) {
                super(QDslAttrPath.class, variable);
            }

            @Override
            @Nullable
            protected SimplePath<UUID> getAttrId() {
                return AbstractRepository.AK.id;
            }

            @Override
            @Nullable
            protected StringPath getAttrKey() {
                return AbstractRepository.AK.key;
            }

            @Override
            @Nullable
            protected SimplePath<UUID> getTargetAttrId() {
                return AbstractRepository.AK.attributeId;
            }

            @Override
            @Nullable
            protected SimplePath<UUID> getTargetAttrDslId() {
                return AbstractRepository.ATTR.datasetlistId;
            }

            SQLQuery<List<?>> getQuery() {
                return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)DataSetListTreeRepository.this.queryFactory.select(this.bindings()).from((Expression)QDslDs.this)).leftJoin((EntityPath)AbstractRepository.AK)).on((Predicate)AbstractRepository.AK.datasetlistId.eq(QDslDs.this.dslId).and((Predicate)AbstractRepository.AK.datasetId.eq(QDslDs.this.dsId)))).leftJoin((EntityPath)AbstractRepository.PARAM)).on((Predicate)AbstractRepository.PARAM.attributeId.eq(AbstractRepository.AK.id))).leftJoin((EntityPath)AbstractRepository.ATTR)).on((Predicate)AbstractRepository.ATTR.id.eq(AbstractRepository.AK.attributeId));
            }
        }

        private abstract class AbstractQDslAttr<T extends AbstractQDslAttr>
        extends TemporaryPathBase<T> {
            SimplePath<UUID> dslId;
            SimplePath<UUID> vaId;
            StringPath dslName;
            SimplePath<UUID> testPlanId;
            SimplePath<UUID> createdBy;
            DateTimePath<Timestamp> createdWhen;
            SimplePath<UUID> modifiedBy;
            DateTimePath<Timestamp> modifiedWhen;
            SimplePath<UUID> dsId;
            BooleanPath dsLocked;
            StringPath dsName;
            NumberPath<Long> dsOrder;
            SimplePath<UUID> attrId;
            StringPath attrName;
            NumberPath<Short> attrType;
            SimplePath<UUID> attrDslRef;
            NumberPath<Integer> attrOrder;
            StringPath attrKey;
            SimplePath<UUID> targetAttrId;
            SimplePath<UUID> targetAttrDslId;
            SimplePath<UUID> paramId;
            StringPath string;
            SimplePath<UUID> list;
            SimplePath<UUID> ds;

            private AbstractQDslAttr(Class<? extends T> type, String variable) {
                super(type, variable);
            }

            @Override
            protected void init() {
                this.dslId = this.delegateSimple(QDslDs.this.dslId);
                this.vaId = this.delegateSimple(QDslDs.this.vaId);
                this.dslName = this.delegateString(QDslDs.this.dslName);
                this.testPlanId = this.delegateSimple(QDslDs.this.testPlanId);
                this.createdBy = this.delegateSimple(QDslDs.this.createdBy);
                this.createdWhen = this.delegateDateTime(QDslDs.this.createdWhen);
                this.modifiedBy = this.delegateSimple(QDslDs.this.modifiedBy);
                this.modifiedWhen = this.delegateDateTime(QDslDs.this.modifiedWhen);
                this.dsId = this.delegateSimple(QDslDs.this.dsId);
                this.dsLocked = this.delegateBoolean(QDslDs.this.dsLocked);
                this.dsName = this.delegateString(QDslDs.this.dsName);
                this.dsOrder = this.delegateNumber(QDslDs.this.dsOrder);
                this.attrId = this.delegateSimple("attr_id", UUID.class, this.getAttrId());
                this.attrName = this.delegateString("attr_name", AbstractRepository.ATTR.name);
                this.attrType = this.delegateNumber("attr_type", AbstractRepository.ATTR.attributeTypeId);
                this.attrDslRef = this.delegateSimple("attr_dsl_ref", AbstractRepository.ATTR.typeDatasetlistId);
                this.attrOrder = this.delegateNumber("attr_order", AbstractRepository.ATTR.ordering);
                this.attrKey = this.delegateString("attr_key", this.getAttrKey());
                this.targetAttrDslId = this.delegateSimple("target_attr_dsl_id", UUID.class, this.getTargetAttrDslId());
                this.targetAttrId = this.delegateSimple("target_attr_id", UUID.class, this.getTargetAttrId());
                this.paramId = this.delegateSimple("param_id", AbstractRepository.PARAM.id);
                this.string = this.delegateString("string", AbstractRepository.PARAM.string);
                this.list = this.delegateSimple("list", AbstractRepository.PARAM.list);
                this.ds = this.delegateSimple("ds", AbstractRepository.PARAM.ds);
            }

            @Nullable
            protected abstract SimplePath<UUID> getAttrId();

            @Nullable
            protected abstract StringPath getAttrKey();

            @Nullable
            protected abstract SimplePath<UUID> getTargetAttrId();

            @Nullable
            protected abstract SimplePath<UUID> getTargetAttrDslId();
        }
    }

    protected static class ToLoadLater
    extends StrongIdentifiedCache {
        private final DataSetListTreeRepository repo;
        private final IdentifiedCache cache;
        private final Multimap<UUID, UUID> loadLater = MultimapBuilder.hashKeys().hashSetValues().build();

        protected ToLoadLater(DataSetListTreeRepository repo, IdentifiedCache cache) {
            this.repo = repo;
            this.cache = cache;
        }

        @Nonnull
        public DataSet provideDsRef(@Nonnull UUID dslId, @Nonnull UUID dsId) {
            this.loadLater.put((Object)dslId, (Object)dsId);
            return Proxies.withId(DataSet.class, dsId, uuid -> {
                DataSet result = this.cache.getIfPresent(DataSet.class, (UUID)uuid);
                if (result != null) {
                    return result;
                }
                Collection uuids = this.loadLater.get((Object)dslId);
                this.repo.getDslTree(dslId, uuids, this);
                return this.cache.getIfPresent(DataSet.class, (UUID)uuid);
            });
        }

        @Nonnull
        public DataSetList provideDslRef(@Nonnull UUID dslId) {
            return Proxies.withId(DataSetList.class, dslId, uuid -> {
                DataSetList result = this.cache.getIfPresent(DataSetList.class, (UUID)uuid);
                if (result != null) {
                    return result;
                }
                Collection uuids = this.loadLater.get((Object)dslId);
                return this.repo.getDslTree(dslId, uuids, this);
            });
        }

        @Nonnull
        public Attribute provideAttr(@Nonnull UUID dslId, @Nonnull UUID attrId) {
            return Proxies.withId(Attribute.class, attrId, uuid -> {
                Attribute result = this.cache.getIfPresent(Attribute.class, attrId);
                if (result != null) {
                    return result;
                }
                Collection uuids = this.loadLater.get((Object)dslId);
                this.repo.getDslTree(dslId, uuids, this);
                return this.cache.getIfPresent(Attribute.class, (UUID)uuid);
            });
        }

        @Override
        @Nonnull
        public <T extends Identified> T computeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
            T result = this.tryComputeIfAbsent(type, id, sourceFunc);
            Preconditions.checkNotNull(result, (String)"[%s] with id [%s] is not provided by [%s]", type, (Object)id, sourceFunc);
            return result;
        }

        @Override
        public <T extends Identified> void put(@Nonnull Class<T> type, @Nonnull T identified) {
            super.put(type, identified);
            this.cache.put(type, identified);
        }
    }

    abstract class TemporaryPathBase<T>
    extends SimplePath<T> {
        protected final Expression<List<?>> bindings;
        protected final Path<?>[] columns;
        private final ImmutableList.Builder<Expression<?>> bindingsBuilder;
        private final List<Path<?>> columnsBuilder;

        TemporaryPathBase(Class<? extends T> type, String variable) {
            super(type, null, variable);
            this.bindingsBuilder = ImmutableList.builder();
            this.columnsBuilder = new LinkedList();
            this.init();
            this.bindings = Projections.list((List)this.bindingsBuilder.build());
            this.columns = this.columnsBuilder.toArray(new Path[this.columnsBuilder.size()]);
        }

        protected abstract void init();

        <V> SimplePath<V> delegateSimple(String property, @Nonnull SimplePath<V> delegate) {
            SimplePath result = Expressions.path((Class)delegate.getType(), (Path)this, (String)property);
            this.bindingsBuilder.add((Object)delegate.as(property));
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        <V> SimplePath<V> delegateSimple(String property, @Nonnull Class<V> type, @Nullable SimplePath<V> delegate) {
            SimpleExpression as;
            SimplePath result = Expressions.path(type, (Path)this, (String)property);
            if (delegate == null) {
                Preconditions.checkArgument((boolean)UUID.class.isAssignableFrom(type), (Object)("Null values casts not supported for type " + type));
                as = Expressions.as((Expression)DataSetListTreeRepository.this.typeSafeNullUuid, (String)property);
            } else {
                as = delegate.as(property);
            }
            this.bindingsBuilder.add((Object)as);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        <V> SimplePath<V> delegateSimple(SimplePath<V> delegate) {
            SimplePath result = Expressions.path((Class)delegate.getType(), (Path)this, (String)delegate.getMetadata().getName());
            this.bindingsBuilder.add(delegate);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        StringPath delegateString(String property, @Nullable StringPath delegate) {
            StringPath result = Expressions.stringPath((Path)this, (String)property);
            Object as = delegate == null ? Expressions.as((Expression)DataSetListTreeRepository.this.typeSafeNullString, (String)property) : delegate.as(property);
            this.bindingsBuilder.add(as);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        StringPath delegateString(StringPath delegate) {
            StringPath result = Expressions.stringPath((Path)this, (String)delegate.getMetadata().getName());
            this.bindingsBuilder.add((Object)delegate);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        <V extends Number> NumberPath<V> delegateNumber(String property, NumberPath<V> delegate) {
            NumberPath result = Expressions.numberPath((Class)delegate.getType(), (Path)this, (String)property);
            this.bindingsBuilder.add((Object)delegate.as(property));
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        <V extends Number> NumberPath<V> delegateNumber(NumberPath<V> delegate) {
            NumberPath result = Expressions.numberPath((Class)delegate.getType(), (Path)this, (String)delegate.getMetadata().getName());
            this.bindingsBuilder.add(delegate);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        BooleanPath delegateBoolean(String property, BooleanPath delegate) {
            BooleanPath result = Expressions.booleanPath((Path)this, (String)property);
            this.bindingsBuilder.add((Object)delegate.as(property));
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        BooleanPath delegateBoolean(BooleanPath delegate) {
            BooleanPath result = Expressions.booleanPath((Path)this, (String)delegate.getMetadata().getName());
            this.bindingsBuilder.add((Object)delegate);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        <V extends Comparable> DateTimePath<V> delegateDateTime(String property, DateTimePath<V> delegate) {
            DateTimePath result = Expressions.dateTimePath((Class)delegate.getType(), (Path)this, (String)property);
            this.bindingsBuilder.add((Object)delegate.as(property));
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        <V extends Comparable> DateTimePath<V> delegateDateTime(DateTimePath<V> delegate) {
            DateTimePath result = Expressions.dateTimePath((Class)delegate.getType(), (Path)this, (String)delegate.getMetadata().getName());
            this.bindingsBuilder.add(delegate);
            this.columnsBuilder.add((Path<?>)result);
            return result;
        }

        public Expression<List<?>> bindings() {
            return this.bindings;
        }

        public Path<?>[] all() {
            return this.columns;
        }
    }
}

