/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.collect.Sets;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.model.Filter;
import org.qubership.atp.dataset.model.impl.FilterImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FilterRepository
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final FilterProjection filterProjection = new FilterProjection();

    @Autowired
    public FilterRepository(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public Filter create(String name, UUID vaId, List<UUID> dsLabels, List<UUID> dslLabels) {
        UUID filterId = (UUID)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)FILTERS).set((Path)FilterRepository.FILTERS.name, (Object)name)).set(FilterRepository.FILTERS.vaId, (Object)vaId)).executeWithKey(FilterRepository.FILTERS.id);
        dsLabels.forEach(dsLabelId -> ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)FILTER_DS_LABELS).set(FilterRepository.FILTER_DS_LABELS.filterId, (Object)filterId)).set(FilterRepository.FILTER_DS_LABELS.dsLabelId, dsLabelId)).execute());
        dslLabels.forEach(dslLabelId -> ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)FILTER_DSL_LABELS).set(FilterRepository.FILTER_DSL_LABELS.filterId, (Object)filterId)).set(FilterRepository.FILTER_DSL_LABELS.dslLabelId, dslLabelId)).execute());
        FilterImpl filter = new FilterImpl(filterId, name);
        filter.setDataSetListLabels(dslLabels);
        filter.setDataSetLabels(dsLabels);
        filter.setVisibilityAreaId(vaId);
        return filter;
    }

    public void onVaDeleteCascade(UUID vaId) {
        List filters = ((SQLQuery)((SQLQuery)this.queryFactory.select(FilterRepository.FILTERS.id).from((Expression)FILTERS)).where((Predicate)FilterRepository.FILTERS.vaId.eq((Object)vaId))).fetch();
        filters.forEach(this::delete);
    }

    public void delete(UUID filterId) {
        this.deleteReferenceToLabel(filterId, FILTER_DSL_LABELS, FilterRepository.FILTER_DSL_LABELS.filterId);
        this.deleteReferenceToLabel(filterId, FILTER_DS_LABELS, FilterRepository.FILTER_DS_LABELS.filterId);
        this.deleteReferenceToLabel(filterId, FILTERS, FilterRepository.FILTERS.id);
    }

    private void deleteReferenceToLabel(UUID filterId, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)filterId))).execute();
    }

    public Filter get(UUID filterId) {
        Filter filter = (Filter)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.filterProjection).from((Expression)FILTERS)).where((Predicate)FilterRepository.FILTERS.id.eq((Object)filterId))).fetchOne();
        if (filter == null) {
            return null;
        }
        this.fillLabels(filter);
        return filter;
    }

    public boolean existsById(UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.filterProjection).from((Expression)FILTERS)).where((Predicate)FilterRepository.FILTERS.id.eq((Object)id))).fetchCount() > 0L;
    }

    private void fillLabels(Filter filter) {
        filter.setDataSetLabels(this.getLabelIds(filter.getId(), FilterRepository.FILTER_DS_LABELS.dsLabelId, FILTER_DS_LABELS, FilterRepository.FILTER_DS_LABELS.filterId));
        filter.setDataSetListLabels(this.getLabelIds(filter.getId(), FilterRepository.FILTER_DSL_LABELS.dslLabelId, FILTER_DSL_LABELS, FilterRepository.FILTER_DSL_LABELS.filterId));
    }

    private List<UUID> getLabelIds(UUID filterId, SimplePath<UUID> labelPth, RelationalPathBase fromPath, SimplePath<UUID> whereClause) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select(labelPth).from((Expression)fromPath)).where((Predicate)whereClause.eq((Object)filterId))).fetch();
    }

    public void update(UUID filterId, String name, List<UUID> dsLabels, List<UUID> dslLabels) {
        ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)FILTERS).set((Path)FilterRepository.FILTERS.name, (Object)name)).where((Predicate)FilterRepository.FILTERS.id.eq((Object)filterId))).execute();
        this.removeOldLabelReferences(filterId, dsLabels, FilterRepository.FILTER_DS_LABELS.filterId, FilterRepository.FILTER_DS_LABELS.dsLabelId, FILTER_DS_LABELS);
        this.removeOldLabelReferences(filterId, dslLabels, FilterRepository.FILTER_DSL_LABELS.filterId, FilterRepository.FILTER_DSL_LABELS.dslLabelId, FILTER_DSL_LABELS);
        this.updateLabels(filterId, dslLabels, FilterRepository.FILTER_DSL_LABELS.filterId, FILTER_DSL_LABELS, FilterRepository.FILTER_DSL_LABELS.dslLabelId);
        this.updateLabels(filterId, dslLabels, FilterRepository.FILTER_DS_LABELS.filterId, FILTER_DS_LABELS, FilterRepository.FILTER_DS_LABELS.dsLabelId);
    }

    private void updateLabels(UUID filterId, List<UUID> labels, SimplePath<UUID> filterIdPath, RelationalPathBase path, SimplePath<UUID> pathLabelId) {
        List<UUID> existingList = this.selectAllExisting(filterId, labels, filterIdPath, path, pathLabelId);
        HashSet labelsToUpdate = Sets.newHashSetWithExpectedSize((int)(labels.size() - existingList.size()));
        existingList.forEach(label -> {
            if (labels.contains(label)) {
                labelsToUpdate.add(label);
            }
        });
        labelsToUpdate.forEach(label -> ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)path).set((Path)filterIdPath, (Object)filterId)).set((Path)pathLabelId, label)).execute());
    }

    private List<UUID> selectAllExisting(UUID filterId, List<UUID> dslLabels, SimplePath<UUID> filterIdPath, RelationalPathBase path, SimplePath<UUID> pathLabelId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select(pathLabelId).from((Expression)path)).where((Predicate)filterIdPath.eq((Object)filterId).and((Predicate)pathLabelId.in(dslLabels)))).fetch();
    }

    private void removeOldLabelReferences(UUID filterId, List<UUID> dsLabels, SimplePath<UUID> filterIdPath, SimplePath<UUID> labelPath, RelationalPathBase labelContainer) {
        List dsLabelsToRemove = ((SQLQuery)((SQLQuery)this.queryFactory.select(labelPath).from((Expression)labelContainer)).where((Predicate)filterIdPath.eq((Object)filterId).and((Predicate)labelPath.notIn(dsLabels)))).fetch();
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)labelContainer).where((Predicate)labelPath.in((Collection)dsLabelsToRemove))).execute();
    }

    public List<Filter> getAll(UUID vaId) {
        List filters = ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.filterProjection).from((Expression)FILTERS)).where((Predicate)FilterRepository.FILTERS.vaId.eq((Object)vaId))).fetch();
        filters.forEach(this::fillLabels);
        return filters;
    }

    private class FilterProjection
    extends MappingProjection<Filter> {
        FilterProjection() {
            super(Filter.class, (Expression[])AbstractRepository.FILTERS.all());
        }

        protected Filter map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.FILTERS.id);
            String name = (String)row.get((Expression)AbstractRepository.FILTERS.name);
            return new FilterImpl(id, name);
        }
    }
}

