/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.VisibilityAreaRepository;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.TestPlanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TestPlanRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TestPlanRepository.class);
    private final TestPlanProjection testPlanProjection;
    private final SQLQueryFactory queryFactory;
    private final Provider<VisibilityAreaRepository> visibilityAreaRepo;
    private final Provider<DataSetListRepository> dslRepo;
    private final CacheRepository cacheRepo;

    @Autowired
    public TestPlanRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull CacheRepository cacheRepo, @Nonnull Provider<VisibilityAreaRepository> visibilityAreaRepo, @Nonnull Provider<DataSetListRepository> dslRepo) {
        this.visibilityAreaRepo = visibilityAreaRepo;
        this.queryFactory = queryFactory;
        this.cacheRepo = cacheRepo;
        this.dslRepo = dslRepo;
        this.testPlanProjection = new TestPlanProjection(this);
    }

    @Nonnull
    public Pair<TestPlan, Boolean> create(@Nonnull String name, @Nonnull UUID visibilityAreaId) {
        UUID testPlanId = null;
        boolean created = false;
        try {
            testPlanId = (UUID)Preconditions.checkNotNull((Object)((UUID)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)TEST_PLAN).set(TestPlanRepository.TEST_PLAN.visibilityAreaId, (Object)visibilityAreaId)).set((Path)TestPlanRepository.TEST_PLAN.name, (Object)name)).executeWithKey(TestPlanRepository.TEST_PLAN.id)), (Object)"nothing created");
            created = true;
        }
        catch (RuntimeException e) {
            try {
                TestPlan testPlan = this.getByNameUnderVisibilityArea(visibilityAreaId, name);
                if (testPlan.getId() != null) {
                    LOG.warn("Test plan with name " + name + " already exists in VA with id: " + visibilityAreaId + ". Test Plan Id: " + testPlanId);
                    testPlanId = testPlan.getId();
                }
                Preconditions.checkNotNull(testPlanId, (Object)"nothing created");
            }
            catch (RuntimeException nested) {
                e.addSuppressed(nested);
                throw e;
            }
        }
        return Pair.of((Object)this.testPlanProjection.create(testPlanId, name, visibilityAreaId), (Object)created);
    }

    @Nullable
    public TestPlan getById(@Nonnull UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(TestPlan.class, id, uuid -> (TestPlan)this.select((Predicate)TestPlanRepository.TEST_PLAN.id.eq(uuid)).fetchOne());
    }

    public boolean existsById(UUID id) {
        return this.cacheRepo.getIfPresent(TestPlan.class, id) != null || this.select((Predicate)TestPlanRepository.TEST_PLAN.id.eq((Object)id)).fetchCount() > 0L;
    }

    @Nonnull
    public List<TestPlan> getAll(@Nonnull UUID visibilityArea) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.testPlanProjection).from((Expression)TEST_PLAN)).where((Predicate)TestPlanRepository.TEST_PLAN.visibilityAreaId.eq((Object)visibilityArea))).fetch();
    }

    @Nonnull
    public List<TestPlan> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.testPlanProjection).from((Expression)TEST_PLAN)).fetch();
    }

    @Nonnull
    protected SQLQuery<TestPlan> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.testPlanProjection).from((Expression)TEST_PLAN)).where(predicate);
    }

    public boolean rename(@Nonnull UUID id, @Nonnull String name) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)TEST_PLAN).where((Predicate)TestPlanRepository.TEST_PLAN.id.eq((Object)id))).set((Path)TestPlanRepository.TEST_PLAN.name, (Object)name)).execute() > 0L;
    }

    void onVaDeleteCascade(UUID vaId) {
        this.getAll(vaId).forEach(testPlan -> this.delete(testPlan.getId(), null, null));
    }

    public boolean delete(@Nonnull UUID id, UUID modifiedBy, Timestamp modifiedWhen) {
        ((DataSetListRepository)this.dslRepo.get()).onTestPlanDeleteCascade(id, modifiedBy, modifiedWhen);
        return this.delete((Predicate)TestPlanRepository.TEST_PLAN.id.eq((Object)id)) > 0L;
    }

    public boolean delete(@Nonnull UUID vaId, @Nonnull String name, UUID modifiedBy, Timestamp modifiedWhen) {
        TestPlan testPlan = this.getByNameUnderVisibilityArea(vaId, name);
        return testPlan != null && this.delete(testPlan.getId(), modifiedBy, modifiedWhen);
    }

    private long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)TEST_PLAN).where(predicate)).execute();
    }

    public TestPlan getByNameUnderVisibilityArea(UUID visibilityArea, String name) {
        return (TestPlan)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.testPlanProjection).from((Expression)TEST_PLAN)).where((Predicate)TestPlanRepository.TEST_PLAN.visibilityAreaId.eq((Object)visibilityArea).and((Predicate)TestPlanRepository.TEST_PLAN.name.eq((Object)name)))).fetchOne();
    }

    private static class TestPlanProjection
    extends MappingProjection<TestPlan> {
        private final TestPlanRepository repo;

        TestPlanProjection(TestPlanRepository repo) {
            super(TestPlan.class, (Expression[])AbstractRepository.TEST_PLAN.all());
            this.repo = repo;
        }

        protected TestPlanImpl map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.TEST_PLAN.id);
            assert (id != null);
            UUID vaId = (UUID)row.get(AbstractRepository.TEST_PLAN.visibilityAreaId);
            assert (vaId != null);
            String name = (String)row.get((Expression)AbstractRepository.TEST_PLAN.name);
            assert (name != null);
            return this.create(id, name, vaId);
        }

        public TestPlanImpl create(@Nonnull UUID testPlanId, @Nonnull String name, @Nonnull UUID visibilityAreaId) {
            VisibilityArea va = Proxies.withId(VisibilityArea.class, visibilityAreaId, uuid -> ((VisibilityAreaRepository)this.repo.visibilityAreaRepo.get()).getById((UUID)uuid));
            return new TestPlanImpl(testPlanId, name, va);
        }
    }
}

