/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.core.metamodel.object.SnapshotType;
import org.qubership.atp.dataset.db.dto.JaversCountResponse;
import org.qubership.atp.dataset.db.jpa.entities.JvSnapshotEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaJvCommitPropertyRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaJvCommitRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaJvGlobalIdRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaJvSnapshotRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JaversSnapshotService {
    private static final Logger log = LoggerFactory.getLogger(JaversSnapshotService.class);
    private static final Integer FIRST_PAGE = 0;
    private final JpaJvSnapshotRepository snapshotRepository;
    private final JpaJvGlobalIdRepository globalIdRepository;
    private final JpaJvCommitRepository commitRepository;
    private final JpaJvCommitPropertyRepository commitPropertyRepository;
    @Value(value="${atp-dataset.archive.job.bulk-delete-count}")
    private Integer bulkDeleteCount;
    @Value(value="${atp-dataset.archive.job.page-size}")
    private Integer size;

    @Autowired
    public JaversSnapshotService(JpaJvSnapshotRepository snapshotRepository, JpaJvGlobalIdRepository globalIdRepository, JpaJvCommitRepository commitRepository, JpaJvCommitPropertyRepository commitPropertyRepository) {
        this.snapshotRepository = snapshotRepository;
        this.globalIdRepository = globalIdRepository;
        this.commitRepository = commitRepository;
        this.commitPropertyRepository = commitPropertyRepository;
    }

    public List<JaversCountResponse> findGlobalIdAndCount(Long lastRevisionCount) {
        List<JaversCountResponse> globalIdAndCount = this.snapshotRepository.findGlobalIdAndCountGreaterThan(lastRevisionCount);
        log.debug("Number of unique globalId '{}'", (Object)globalIdAndCount.size());
        return globalIdAndCount;
    }

    public List<JvSnapshotEntity> findOldSnapshots(Long globalId, Long count) {
        PageRequest pageRequest = PageRequest.of((int)0, (int)Math.toIntExact(count));
        List<JvSnapshotEntity> oldSnapshots = this.snapshotRepository.findAllByGlobalIdOrderByVersionAsc(globalId, (Pageable)pageRequest);
        log.debug("Number of old snapshots '{}' for globalId '{}'", (Object)oldSnapshots.size(), (Object)globalId);
        return oldSnapshots;
    }

    public JvSnapshotEntity findTheOldestSnapshotByGlobalIdAndUpdateTypeAsInitial(Long globalId) {
        JvSnapshotEntity snapshot = this.snapshotRepository.findFirstByGlobalIdOrderByVersionAsc(globalId);
        if (Objects.isNull(snapshot)) {
            return null;
        }
        snapshot.setType(SnapshotType.INITIAL);
        return (JvSnapshotEntity)this.snapshotRepository.save(snapshot);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOldAndUpdateAsInitial(Long globalId, List<JvSnapshotEntity> snapshots) {
        snapshots.forEach(snapshot -> this.deleteOldAndUpdateAsInitial(globalId, (JvSnapshotEntity)snapshot));
        this.findTheOldestSnapshotByGlobalIdAndUpdateTypeAsInitial(globalId);
    }

    private void deleteOldAndUpdateAsInitial(Long globalId, JvSnapshotEntity snapshot) {
        Long commitId = snapshot.getCommitId();
        Long version = snapshot.getVersion();
        this.snapshotRepository.deleteByVersionAndGlobalIdAndCommitId(version, globalId, commitId);
        log.debug("Deleted snapshots with version '{}', globalId '{}', commitId '{}'", new Object[]{version, globalId, commitId});
        Long commitCount = this.snapshotRepository.countByCommitId(commitId);
        if (commitCount.equals(0L)) {
            this.commitPropertyRepository.deleteByIdCommitId(commitId);
            this.commitRepository.deleteById(commitId);
            log.debug("Deleted commit properties and commits with commitId '{}'", (Object)commitId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTerminatedSnapshots() {
        Page<JvSnapshotEntity> page;
        do {
            page = this.snapshotRepository.findAllByTypeIs(SnapshotType.TERMINAL, (Pageable)PageRequest.of((int)FIRST_PAGE, (int)this.size));
            this.deleteTerminatedSnapshots(page);
        } while (page.hasNext());
    }

    private void deleteTerminatedSnapshots(Page<JvSnapshotEntity> page) {
        List terminalSnapshots = page.getContent();
        Set<Long> globalIds = this.getIds(terminalSnapshots, JvSnapshotEntity::getGlobalId);
        log.debug("Number of terminal globalIds '{}'", (Object)globalIds.size());
        ArrayList snapshots = new ArrayList();
        this.doAction(globalIds, ids -> snapshots.addAll(this.snapshotRepository.findAllByGlobalIdIn((Collection<Long>)ids)));
        Set<Long> commitIds = this.getIds(snapshots, JvSnapshotEntity::getCommitId);
        log.debug("Number of terminal commitIds '{}'", (Object)commitIds.size());
        this.doAction(globalIds, this.snapshotRepository::deleteByGlobalIdIn);
        log.debug("Terminated snapshots deleted");
        this.doAction(globalIds, this.globalIdRepository::deleteByIdIn);
        log.debug("Terminated globalIds deleted");
        this.doAction(commitIds, this.commitPropertyRepository::deleteByIdCommitIdIn);
        log.debug("Terminated commit properties deleted");
        this.doAction(commitIds, this.commitRepository::deleteByIdIn);
        log.debug("Terminated commits deleted");
    }

    private <T> void doAction(Collection<T> collection, Consumer<? super List<T>> action) {
        Iterators.partition(collection.iterator(), (int)this.bulkDeleteCount).forEachRemaining(action);
    }

    private <T, R> Set<R> getIds(List<T> snapshots, Function<T, R> function) {
        return snapshots.stream().map(function).collect(Collectors.toSet());
    }
}

