/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.entities;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;

@Entity
@Table(name="attribute_key")
public class AttributeKeyEntity
extends AbstractAttributeEntity {
    private static final long serialVersionUID = 9009718864988359127L;
    @Column(name="key")
    private String key;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dataset_id")
    public DataSetEntity dataSet;
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="attribute_id")
    public AttributeEntity attribute;

    @Override
    public boolean isAttributeKey() {
        return true;
    }

    @Override
    public UUID getOriginAttributeId() {
        return this.attribute.getId();
    }

    @Override
    public String getName() {
        return this.attribute.getName();
    }

    @Transient
    public List<UUID> getPath() {
        String[] splitResult;
        LinkedList<UUID> result = new LinkedList<UUID>();
        for (String splitPart : splitResult = this.key.split("_")) {
            result.add(UUID.fromString(splitPart));
        }
        return result;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDataSet(DataSetEntity dataSet) {
        this.dataSet = dataSet;
    }

    public void setAttribute(AttributeEntity attribute) {
        this.attribute = attribute;
    }

    public String getKey() {
        return this.key;
    }

    public DataSetEntity getDataSet() {
        return this.dataSet;
    }

    public AttributeEntity getAttribute() {
        return this.attribute;
    }
}

