/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.repositories;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetRepositoryCustom;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface JpaDataSetRepository
extends JpaRepository<DataSetEntity, UUID>,
JpaDataSetRepositoryCustom,
PagingAndSortingRepository<DataSetEntity, UUID> {
    public List<DataSetEntity> findByDataSetList(DataSetListEntity var1);

    public Optional<DataSetEntity> findById(UUID var1);

    @Query(value="select ds from DataSetEntity ds where ds.name LIKE %:name%")
    public Page<DataSetEntity> findAllByNameContains(@Param(value="name") String var1, Pageable var2);

    @Query(value="select ds from DataSetEntity ds where ds.name LIKE %:name% and ds.dataSetList.id in :dsl_id")
    public Optional<Page<DataSetEntity>> findAllByNameContainsAndDslIn(@Param(value="name") String var1, @Param(value="dsl_id") List<UUID> var2, Pageable var3);

    public List<DataSetEntity> findByNameAndDataSetListId(String var1, UUID var2);

    public List<DataSetEntity> findByDataSetListId(UUID var1);

    public List<DataSetEntity> findByDataSetListIdIn(Collection<UUID> var1);

    public List<DataSetEntity> findBySourceIdAndDataSetListId(UUID var1, UUID var2);

    public List<DataSetEntity> findByDataSetListIdAndLocked(UUID var1, Boolean var2);

    @Query(value="select ds.name from DataSetEntity ds where ds.dataSetList.id = ?1")
    public List<String> getDsNames(UUID var1);

    @Query(value="select d.dataSetList.id  from DataSetEntity d where d.id = ?1")
    public Optional<UUID> getDslId(UUID var1);

    @Query(value="select cast(datasetlist_id as varchar) from dataset where id = :ds_id", nativeQuery=true)
    public UUID getDataSetsListIdByDataSetId(@Param(value="ds_id") UUID var1);

    @Query(value="select d.locked  from DataSetEntity d where d.id = ?1")
    public boolean isLocked(UUID var1);
}

