/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration.v1;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.auth.springbootstarter.entities.ServiceEntities;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.dataset.config.BeanAwareSpringLiquibase;
import org.qubership.atp.dataset.model.UserManagementEntities;

public class ServiceEntitiesMigrationCustomChange
implements CustomTaskChange {
    private String serviceName;
    private static final UUID SERVICE_ENTITIES_ID = UUID.fromString("f8eceec9-a987-448a-9e27-4a60b281d18c");

    public void execute(Database database) {
        ServiceEntities entities = new ServiceEntities();
        entities.setUuid(SERVICE_ENTITIES_ID);
        entities.setService(this.serviceName);
        entities.setEntities(Arrays.stream(UserManagementEntities.values()).map(UserManagementEntities::getName).collect(Collectors.toList()));
        UsersService usersService = BeanAwareSpringLiquibase.getBean(UsersService.class);
        usersService.sendEntities(entities);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

