/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.dataset.antlr4.TextParameterParser;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetListRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetRepository;
import org.qubership.atp.dataset.ei.model.DataSet;
import org.qubership.atp.dataset.ei.model.DataSetAttribute;
import org.qubership.atp.dataset.ei.model.DataSetAttributeKey;
import org.qubership.atp.dataset.ei.model.DataSetList;
import org.qubership.atp.dataset.ei.model.DataSetListValue;
import org.qubership.atp.dataset.ei.model.DataSetParameter;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.impl.ei.postman.ExportPostmanDataset;
import org.qubership.atp.dataset.model.impl.ei.postman.ExportPostmanParameter;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListContextService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.JpaDataSetServiceImpl;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.GroupContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.RefDslMacro;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.atp.ei.ntt.impl.NttProjectConverter;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.converter.MacrosDtoConvertService;
import org.qubership.atp.macros.core.model.Macros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DataSetExportExecutor
implements ExportExecutor {
    private static final Logger log = LoggerFactory.getLogger(DataSetExportExecutor.class);
    @Value(value="${spring.application.name}")
    private String implementationName;
    private static final String DATASET = "dataset";
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final ObjectWriter objectWriter;
    private final JpaDataSetRepository dataSetRepository;
    private final JpaDataSetListRepository dataSetListRepository;
    private final GridFsRepository gridFsRepository;
    private final MacroContextService macroContextService;
    private final DataSetListContextService dataSetListContextService;
    private final FileService fileService;
    private final JpaDataSetListService dslService;
    private final JpaDataSetServiceImpl dsService;
    private final DataSetParameterProvider dataSetParameterProvider;
    private final MacrosFeignClient macrosFeignClient;
    private final MacrosCalculator macrosCalculator;

    public DataSetExportExecutor(ObjectSaverToDiskService objectSaverToDiskService, ObjectMapper exportObjectMapper, JpaDataSetRepository dataSetRepository, JpaDataSetListRepository dataSetListRepository, GridFsRepository gridFsRepository, MacroContextService macroContextService, DataSetListContextService dataSetListContextService, FileService fileService, JpaDataSetListService dslService, JpaDataSetServiceImpl dsService, DataSetParameterProvider dataSetParameterProvider, MacrosFeignClient macrosFeignClient, MacrosCalculator macrosCalculator) {
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.objectWriter = exportObjectMapper.writer();
        this.dataSetRepository = dataSetRepository;
        this.dataSetListRepository = dataSetListRepository;
        this.gridFsRepository = gridFsRepository;
        this.macroContextService = macroContextService;
        this.dataSetListContextService = dataSetListContextService;
        this.fileService = fileService;
        this.dslService = dslService;
        this.dsService = dsService;
        this.dataSetParameterProvider = dataSetParameterProvider;
        this.macrosFeignClient = macrosFeignClient;
        this.macrosCalculator = macrosCalculator;
    }

    public void exportToFolder(ExportImportData exportData, Path workDir) throws Exception {
        log.info("Start export by request {}", (Object)exportData);
        switch (exportData.getFormat()) {
            case ATP: {
                this.atpExport(exportData, workDir);
                break;
            }
            case NTT: {
                this.nttExport(exportData, workDir);
                break;
            }
            case POSTMAN: {
                this.postmanExport(exportData, workDir);
                break;
            }
            default: {
                log.error("Export data unformatted: {}", (Object)exportData.getFormat());
            }
        }
        log.info("Finish export by request {}", (Object)exportData);
    }

    private void atpExport(ExportImportData exportData, Path workDir) {
        log.info("Start ATP export by request {}", (Object)exportData);
        this.expandExportScope(exportData);
        this.exportProjectByScope(exportData, workDir);
        log.info("Finish ATP export by request {}", (Object)exportData);
    }

    private void nttExport(ExportImportData exportData, Path workDir) {
        this.atpExport(exportData, workDir);
        UUID vaId = exportData.getProjectId();
        log.info("Converting to ntt project. Project id {}", (Object)vaId);
        this.convertToNttFormat(workDir);
    }

    protected void expandExportScope(ExportImportData exportData) {
        Set exportScopeDatasetStorage;
        Set allDslByVa = this.dataSetListRepository.getDslIdsByVa(exportData.getProjectId()).stream().map(UUID::toString).collect(Collectors.toSet());
        if (allDslByVa.equals(exportScopeDatasetStorage = (Set)exportData.getExportScope().getEntities().getOrDefault("datasetStorage", new HashSet()))) {
            log.info("Exporting all dsls for project, no expand export scope needed");
            return;
        }
        Set exportScopeDatasets = exportData.getExportScope().getEntities().getOrDefault("datasets", new HashSet());
        HashSet<String> collectedDs = new HashSet<String>(exportScopeDatasets);
        HashSet<String> collectedDsl = new HashSet<String>();
        HashMap<UUID, LinkedList<UUID>> context = new HashMap<UUID, LinkedList<UUID>>();
        for (String dataSetId : exportScopeDatasets) {
            this.collectReferencesOnDsAndCorrespondingDsl(dataSetId, collectedDs, collectedDsl, null, null, context, false, true, null);
        }
        exportData.getExportScope().getEntities().put("datasets", collectedDs);
        exportScopeDatasetStorage.addAll(collectedDsl);
        collectedDsl = new HashSet(exportScopeDatasetStorage);
        for (String dataSetListId : exportScopeDatasetStorage) {
            this.collectReferencesOnDslFromAttribute(dataSetListId, collectedDsl);
        }
        log.debug("collectedDsl {}", collectedDsl);
        exportScopeDatasetStorage.addAll(collectedDsl);
        exportData.getExportScope().getEntities().put("datasetStorage", exportScopeDatasetStorage);
    }

    private void collectReferencesOnDslFromAttribute(String dataSetListId, Set<String> collectedDsl) {
        log.debug("start collectReferencesOnDslFromAttribute(dataSetListId: {})", (Object)dataSetListId);
        collectedDsl.add(dataSetListId);
        Optional<DataSetListEntity> dataSetListEntity = this.dataSetListRepository.findById(UUID.fromString(dataSetListId));
        if (!dataSetListEntity.isPresent()) {
            log.info("Data Set List not found by id {}", (Object)dataSetListId);
            return;
        }
        HashSet<UUID> dataSetLists = new HashSet<UUID>();
        List<AttributeEntity> attributes = dataSetListEntity.get().getAttributes();
        for (AttributeEntity attribute : attributes) {
            if (!attribute.getAttributeTypeId().equals(AttributeType.DSL.getId())) continue;
            dataSetLists.add(attribute.getTypeDataSetListId());
        }
        for (UUID dslId : dataSetLists) {
            if (collectedDsl.contains(dslId.toString())) continue;
            this.collectReferencesOnDslFromAttribute(dslId.toString(), collectedDsl);
        }
    }

    private void collectReferencesOnDsAndCorrespondingDsl(String dataSetId, Set<String> alreadyCollectedDs, Set<String> alreadyCollectedDsl, MacroContext macroContext, List<UUID> attrPath, Map<UUID, LinkedList<UUID>> context, boolean notFromReference, boolean firstEnter, UUID lastRefDsBeforeMacrosId) {
        log.debug("start collectReferencesOnDsAndCorrespondingDsl(dataSetId: {}, macroContext: {}, attrPath: {})", new Object[]{dataSetId, macroContext, attrPath});
        alreadyCollectedDs.add(dataSetId);
        Optional<DataSetEntity> dataSet = this.dataSetRepository.findById(UUID.fromString(dataSetId));
        if (!dataSet.isPresent()) {
            log.info("Data Set not found by id {}", (Object)dataSetId);
            return;
        }
        UUID dataSetListId = dataSet.get().getDataSetList().getId();
        alreadyCollectedDsl.add(dataSetListId.toString());
        if (macroContext == null) {
            macroContext = new MacroContext();
            macroContext.setMacroContextService(this.macroContextService);
            DataSetListContext dataSetListContext = this.dataSetListContextService.getDataSetListContext(dataSetListId, Collections.emptyList(), Collections.emptyList(), null);
            macroContext.setDataSetListContext(dataSetListContext);
        }
        if (attrPath == null) {
            attrPath = new ArrayList<UUID>();
        }
        if (firstEnter) {
            lastRefDsBeforeMacrosId = UUID.fromString(dataSetId);
        }
        List<ParameterEntity> params = dataSet.get().getParameters();
        for (ParameterEntity param : params) {
            log.debug("Parameter Entity id {}", (Object)param.getId());
            ArrayList<UUID> attrPathInner = new ArrayList<UUID>();
            if (param.getAttribute().isAttributeKey()) {
                AttributeKey key = new Parameter(param).getAttributeKey();
                if (key != null) {
                    attrPathInner.addAll(key.getPath());
                }
            } else {
                attrPathInner.addAll(attrPath);
            }
            UUID dataSetReferenceId = param.getDataSetReferenceId();
            log.debug("dataSetReferenceId {}", (Object)dataSetReferenceId);
            HashSet<UUID> dataSetsFromReference = new HashSet<UUID>();
            HashSet<UUID> dataSetsFromMacros = new HashSet<UUID>();
            HashSet<UUID> dataSetList = new HashSet<UUID>();
            if (dataSetReferenceId != null) {
                dataSetsFromReference.add(dataSetReferenceId);
                attrPathInner.add(param.getAttribute().getOriginAttributeId());
            } else {
                this.collectReferencesFromParamValue(param.getStringValue(), dataSetsFromMacros, dataSetList, macroContext, attrPathInner, UUID.fromString(dataSetId), context, notFromReference, lastRefDsBeforeMacrosId);
            }
            for (UUID dsId : dataSetsFromReference) {
                if (alreadyCollectedDs.contains(dsId.toString())) continue;
                this.collectReferencesOnDsAndCorrespondingDsl(dsId.toString(), alreadyCollectedDs, alreadyCollectedDsl, macroContext, attrPathInner, context, false, false, lastRefDsBeforeMacrosId);
            }
            for (UUID dsId : dataSetsFromMacros) {
                if (alreadyCollectedDs.contains(dsId.toString())) continue;
                this.collectReferencesOnDsAndCorrespondingDsl(dsId.toString(), alreadyCollectedDs, alreadyCollectedDsl, null, null, context, true, false, lastRefDsBeforeMacrosId);
            }
            alreadyCollectedDsl.addAll(dataSetList.stream().map(UUID::toString).collect(Collectors.toSet()));
        }
    }

    private void collectReferencesFromParamValue(String parameterString, Set<UUID> dataSets, Set<UUID> dataSetLists, MacroContext macroContext, List<UUID> parameterPath, UUID dataSetId, Map<UUID, LinkedList<UUID>> context, boolean notFromReference, UUID lastRefDsBeforeMacrosId) {
        log.debug("start collectReferencesFromParamValue(parameterString: {}, macroContext: {}, parameterPath: {})", new Object[]{parameterString, macroContext, parameterPath});
        if (parameterString == null) {
            return;
        }
        int dataSetPosition = notFromReference ? this.getDataSetPositionFromContextOrDb(dataSetId, context) : this.getDataSetPositionFromContextOrDb(lastRefDsBeforeMacrosId, context);
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(parameterPath, dataSetPosition, null, 0L, null);
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        List<AbstractTextParameter> parseResult = parser.parse(parameterString, true);
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            abstractTextParameter.getValue();
            this.walkThroughResultTree(abstractTextParameter, dataSets, dataSetLists);
        }
    }

    private int getDataSetPositionFromContextOrDb(UUID dataSetId, Map<UUID, LinkedList<UUID>> context) {
        UUID dataSetListId = this.dsService.getDataSetsListIdByDataSetId(dataSetId);
        if (!context.containsKey(dataSetListId)) {
            LinkedList<UUID> dataSetsOrders = this.dslService.getDataSetsIdsByDataSetListId(dataSetListId);
            context.put(dataSetListId, dataSetsOrders);
        }
        LinkedList<UUID> datasetIds = context.get(dataSetListId);
        log.error("MacrosContext DataSet Id: " + dataSetId + ", position: " + datasetIds.indexOf(dataSetId) + ", datasetIds: " + datasetIds);
        return datasetIds.indexOf(dataSetId);
    }

    private void walkThroughResultTree(AbstractTextParameter parseResult, Set<UUID> dataSets, Set<UUID> dataSetLists) {
        List<AbstractTextParameter> children = parseResult.getChildTextParameters();
        if (!CollectionUtils.isEmpty(children)) {
            for (AbstractTextParameter parameter : children) {
                this.walkThroughResultTree(parameter, dataSets, dataSetLists);
            }
        }
        if (parseResult instanceof RefDslMacro) {
            dataSets.addAll(((RefDslMacro)parseResult).getDataSets());
            dataSetLists.addAll(((RefDslMacro)parseResult).getDataSetLists());
        }
    }

    private void convertToNttFormat(Path workDir) throws ExportException {
        log.info("Starting to convert to ntt using export source dir {}", (Object)workDir);
        try {
            new NttProjectConverter(workDir).convertDataSet().saveToFolder(workDir);
        }
        catch (Exception e) {
            log.error("NttConverter exception {}", (Object)workDir, (Object)e);
            ExportException.throwException((String)"Cannot convert export to NTT format. Work dir {}", (Object[])new Object[]{workDir, e});
        }
    }

    private void exportProjectByScope(ExportImportData atpScopeData, Path workDir) throws ExportException {
        ExportScope atpScopeExport = atpScopeData.getExportScope();
        HashMap<UUID, Short> attributeTypes = new HashMap<UUID, Short>();
        Set exportScopeDatasetStorage = atpScopeExport.getEntities().getOrDefault("datasetStorage", new HashSet());
        for (String dataSetListId : exportScopeDatasetStorage) {
            this.exportDataSetStorage(UUID.fromString(dataSetListId), workDir, attributeTypes, atpScopeExport);
        }
        Set exportScopeDatasets = atpScopeExport.getEntities().getOrDefault("datasets", new HashSet());
        for (String dataSetId : exportScopeDatasets) {
            this.exportDataSet(UUID.fromString(dataSetId), workDir, attributeTypes, atpScopeExport);
        }
    }

    private void exportDataSet(UUID dataSetId, Path workDir, Map<UUID, Short> attributeTypes, ExportScope atpScopeExport) {
        Optional<DataSetEntity> dataSet = this.dataSetRepository.findById(dataSetId);
        if (!dataSet.isPresent()) {
            log.info("Data Set not found by id {}", (Object)dataSetId);
            return;
        }
        DataSet eds = new DataSet(dataSet.get().getId(), dataSet.get().getName());
        UUID parentId = dataSet.get().getDataSetList().getId();
        eds.setDataSetList(parentId);
        eds.setOrdering(dataSet.get().getOrdering());
        eds.setIsLocked(dataSet.get().isLocked());
        this.objectSaverToDiskService.exportAtpEntity(dataSetId, (Object)eds, parentId, workDir);
        ArrayList<UUID> idsOfFileParameters = new ArrayList<UUID>();
        List<ParameterEntity> params = dataSet.get().getParameters();
        for (ParameterEntity param : params) {
            AbstractAttributeEntity attribute = param.getAttribute();
            if (attribute != null) {
                UUID dataSetListId = attribute.getDataSetList().getId();
                if (!((Set)atpScopeExport.getEntities().getOrDefault("datasetStorage", new HashSet())).contains(dataSetListId.toString())) continue;
            }
            this.exportParameter(param, dataSetId, workDir, attributeTypes, idsOfFileParameters);
        }
        if (!idsOfFileParameters.isEmpty()) {
            this.exportFiles(idsOfFileParameters, dataSet.get(), workDir);
        }
    }

    private void exportFiles(List<UUID> idsOfFileParameters, DataSetEntity dataSet, Path workDir) {
        Map<UUID, Optional<InputStream>> files = this.gridFsRepository.getAll(idsOfFileParameters);
        for (Map.Entry<UUID, Optional<InputStream>> entry : files.entrySet()) {
            UUID parameterId = entry.getKey();
            Optional<InputStream> file = entry.getValue();
            if (!file.isPresent()) continue;
            Optional<FileData> fileInfo = this.gridFsRepository.getFileInfo(parameterId);
            if (!fileInfo.isPresent()) {
                log.info("File not found for parameter with id {}", (Object)parameterId);
                continue;
            }
            FileData fileData = fileInfo.get();
            UUID datasetListIdentifier = dataSet.getDataSetList().getId();
            UUID datasetIdentifier = dataSet.getId();
            this.saveDataSetFile(fileData, datasetListIdentifier, datasetIdentifier, workDir, file);
        }
    }

    private void checkListValueParameter(ParameterEntity param, ListValueEntity listValue, DataSetParameter exportParameter, Path workDir) {
        AttributeEntity listValueAttr = listValue.getAttribute();
        AbstractAttributeEntity paramAttr = param.getAttribute();
        if (paramAttr instanceof AttributeEntity) {
            UUID attrListValueId;
            UUID attrParamId = paramAttr.getId();
            if (!attrParamId.equals(attrListValueId = listValueAttr.getId())) {
                Optional<ListValueEntity> optionalListValue = ((AttributeEntity)paramAttr).getListValues().stream().filter(value -> value.getText().equals(listValue.getText())).findFirst();
                if (optionalListValue.isPresent()) {
                    exportParameter.setListValue(optionalListValue.get().getId());
                } else {
                    UUID newId = UUID.randomUUID();
                    DataSetListValue listValueExport = new DataSetListValue();
                    listValueExport.setAttribute(attrParamId);
                    listValueExport.setId(newId);
                    listValueExport.setText(listValue.getText());
                    this.objectSaverToDiskService.exportAtpEntity(listValueExport.getId(), (Object)listValueExport, listValueExport.getAttribute(), workDir);
                    exportParameter.setListValue(newId);
                }
            } else {
                exportParameter.setListValue(listValue.getId());
            }
        } else {
            exportParameter.setListValue(listValue.getId());
        }
    }

    private void exportParameter(ParameterEntity param, UUID dataSetId, Path workDir, Map<UUID, Short> attributeTypes, List<UUID> idsOfFileParameters) {
        DataSetParameter exportParameter = new DataSetParameter(param.getId());
        exportParameter.setDataSet(dataSetId);
        ListValueEntity listValue = param.getListValue();
        if (listValue != null) {
            this.checkListValueParameter(param, listValue, exportParameter, workDir);
        }
        exportParameter.setAttribute(param.getAttribute().getId());
        Short getAttributeType = attributeTypes.get(param.getAttribute().getId());
        if (Objects.equals(AttributeType.ENCRYPTED.getId(), getAttributeType)) {
            exportParameter.setStringValue(null);
        } else {
            exportParameter.setStringValue(param.getStringValue());
        }
        exportParameter.setDataSetReferenceValue(param.getDataSetReferenceId());
        exportParameter.setFileValueId(param.getFileValueId());
        this.objectSaverToDiskService.exportAtpEntity(param.getId(), (Object)exportParameter, param.getDataSet().getId(), workDir);
        if (Objects.equals(AttributeType.FILE.getId(), getAttributeType)) {
            idsOfFileParameters.add(param.getId());
        }
    }

    private void exportDataSetStorage(UUID dataSetListId, Path workDir, Map<UUID, Short> attributeTypes, ExportScope atpScopeExport) {
        Optional<DataSetListEntity> dataSetListEntity = this.dataSetListRepository.findById(dataSetListId);
        if (!dataSetListEntity.isPresent()) {
            log.info("Data Set List not found by id {}", (Object)dataSetListId);
            return;
        }
        UUID vaId = dataSetListEntity.get().getVisibilityArea().getId();
        DataSetList dataSetList = new DataSetList(dataSetListEntity.get().getId(), dataSetListEntity.get().getName());
        dataSetList.setTestPlan(dataSetListEntity.get().getTestPlan() == null ? null : dataSetListEntity.get().getTestPlan().getId());
        dataSetList.setVisibilityArea(vaId);
        dataSetList.setCreatedBy(dataSetListEntity.get().getCreatedBy());
        dataSetList.setCreatedWhen(dataSetListEntity.get().getCreatedWhen());
        dataSetList.setModifiedBy(dataSetListEntity.get().getModifiedBy());
        dataSetList.setModifiedWhen(dataSetListEntity.get().getModifiedWhen());
        this.objectSaverToDiskService.exportAtpEntity(dataSetListId, (Object)dataSetList, vaId, workDir);
        List<AttributeEntity> attributes = dataSetListEntity.get().getAttributes();
        for (AttributeEntity attribute : attributes) {
            this.exportAttribute(attribute, workDir);
            attributeTypes.put(attribute.getId(), attribute.getAttributeTypeId().shortValue());
        }
        Set<AttributeKeyEntity> attKeys = dataSetListEntity.get().getAttributeKeys();
        for (AttributeKeyEntity attrKey : attKeys) {
            if (!((Set)atpScopeExport.getEntities().getOrDefault("datasets", new HashSet())).contains(attrKey.getDataSet().getId().toString())) continue;
            this.exportAttributeKey(attrKey, workDir);
            AttributeEntity attribute = attrKey.getAttribute();
            this.exportAttribute(attribute, workDir);
            attributeTypes.put(attrKey.getId(), attribute.getAttributeTypeId().shortValue());
        }
    }

    private void exportAttributeKey(AttributeKeyEntity attribute, Path workDir) throws ExportException {
        DataSetAttributeKey exportAttribute = new DataSetAttributeKey(attribute.getId(), attribute.getKey());
        exportAttribute.setAttribute(attribute.getAttribute().getId());
        exportAttribute.setDataSetList(attribute.getDataSetList().getId());
        exportAttribute.setDataSet(attribute.getDataSet().getId());
        this.objectSaverToDiskService.exportAtpEntity(attribute.getId(), (Object)exportAttribute, attribute.getDataSetList().getId(), workDir);
    }

    private void exportAttribute(AttributeEntity attribute, Path workDir) throws ExportException {
        DataSetAttribute exportAttribute = new DataSetAttribute(attribute.getId(), attribute.getName());
        exportAttribute.setAttributeType(attribute.getAttributeTypeId());
        exportAttribute.setDataSetList(attribute.getDataSetList().getId());
        exportAttribute.setOrdering(attribute.getOrdering());
        exportAttribute.setTypeDataSetList(attribute.getTypeDataSetListId());
        this.objectSaverToDiskService.exportAtpEntity(attribute.getId(), (Object)exportAttribute, attribute.getDataSetList().getId(), workDir);
        List<ListValueEntity> listValues = attribute.getListValues();
        if (listValues != null) {
            for (ListValueEntity lv : listValues) {
                DataSetListValue listValue = new DataSetListValue();
                listValue.setAttribute(attribute.getId());
                listValue.setId(lv.getId());
                listValue.setText(lv.getText());
                this.objectSaverToDiskService.exportAtpEntity(listValue.getId(), (Object)listValue, listValue.getAttribute(), workDir);
            }
        }
    }

    private void saveDataSetFile(FileData fileData, UUID datasetListIdentifier, UUID datasetIdentifier, Path workDir, Optional<InputStream> file) throws ExportException {
        Path dataSetFilesPath = workDir.resolve("files").resolve(datasetListIdentifier.toString()).resolve(datasetIdentifier.toString());
        this.fileService.createDirectory(dataSetFilesPath);
        String fileName = fileData.getParameterUuid().toString();
        try (InputStream in = file.get();){
            Path filePath = dataSetFilesPath.resolve(fileName);
            Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ExportException.throwException((String)"Cannot save file {} on disk {}", (Object[])new Object[]{fileName, dataSetFilesPath});
        }
        Path filePath = this.fileService.createFile(fileName + ".json", dataSetFilesPath);
        try {
            this.objectWriter.writeValue(filePath.toFile(), (Object)fileData);
        }
        catch (IOException e) {
            log.error("Cannot write object {} in file {}", new Object[]{fileData, filePath, e});
            ExportException.throwException((String)"Cannot write object {} in file ", (Object[])new Object[]{fileData, filePath.toString(), e});
        }
    }

    public String getExportImplementationName() {
        return this.implementationName;
    }

    private void postmanExport(ExportImportData exportData, Path workDir) {
        log.info("Start Postman export by request {}", (Object)exportData);
        Set exportScopeDatasetStorage = exportData.getExportScope().getEntities().getOrDefault("datasetStorage", new HashSet());
        for (String dataSetListId : exportScopeDatasetStorage) {
            this.exportDatasetList(UUID.fromString(dataSetListId), workDir);
        }
        log.info("Finish Postman export by request {}", (Object)exportData);
    }

    private void exportDatasetList(UUID dataSetListId, Path workDir) {
        DataSetListContext dataSetListContext = this.createDataSetListContext(dataSetListId);
        MacroContext macroContext = this.createMacrosContext(dataSetListContext);
        for (DataSetContext dataset : dataSetListContext.getDataSets()) {
            this.exportDataset(dataset, macroContext, dataSetListContext, workDir);
        }
    }

    private DataSetListContext createDataSetListContext(UUID dataSetListId) {
        AttributeTypeName[] attributesToLoad = new AttributeTypeName[]{AttributeTypeName.TEXT, AttributeTypeName.ENCRYPTED, AttributeTypeName.LIST, AttributeTypeName.FILE, AttributeTypeName.CHANGE, AttributeTypeName.DSL};
        List<Integer> columnsToLoad = this.dslService.getById(dataSetListId).getDataSetsColumns(this.dataSetListRepository.getDataSetsIdsByDataSetListId(dataSetListId));
        return this.dataSetListContextService.getDataSetListContext(dataSetListId, columnsToLoad, Arrays.asList(attributesToLoad), null);
    }

    private MacroContext createMacrosContext(DataSetListContext dataSetListContext) {
        MacroContext macroContext = new MacroContext();
        macroContext.setMacroContextService(this.macroContextService);
        macroContext.setMacrosCalculator(this.macrosCalculator);
        List macrosDtoList = (List)this.macrosFeignClient.findAllByProject(dataSetListContext.getVisibilityAreaId()).getBody();
        List macros = new MacrosDtoConvertService().convertList(macrosDtoList, Macros.class);
        macroContext.setMacros(macros);
        macroContext.setDataSetListContext(dataSetListContext);
        return macroContext;
    }

    private void exportDataset(DataSetContext dataset, MacroContext macroContext, DataSetListContext dataSetListContext, Path workDir) {
        ArrayList<ExportPostmanParameter> parameters = new ArrayList<ExportPostmanParameter>();
        for (ParameterContext param : dataset.getParameters()) {
            this.processParameter(param, dataset, macroContext, dataSetListContext.getGroups(), parameters, null);
        }
        String dsName = String.format("%s.%s", dataSetListContext.getDataSetListName(), dataset.getName());
        String fileName = String.format("%s.%s", dsName, DATASET);
        ExportPostmanDataset exportDataset = new ExportPostmanDataset(dataset.getId(), dsName, parameters);
        this.objectSaverToDiskService.writeAtpEntityToFile(fileName, (Object)exportDataset, DATASET, workDir, true);
    }

    private void processParameter(ParameterContext param, DataSetContext dataset, MacroContext macroContext, List<GroupContext> groups, List<ExportPostmanParameter> parameters, @Nullable String attrPath) {
        String path = this.getPath(attrPath, param.getName());
        if (param.getType().equals((Object)AttributeTypeName.DSL)) {
            if (param.getValue() == null) {
                parameters.add(new ExportPostmanParameter(path, ""));
            } else {
                parameters.add(new ExportPostmanParameter(path, param.getValue()));
                GroupContext groupContext = groups.stream().filter(group -> param.getOrder() == group.getOrder()).findFirst().get();
                this.processGroup(param, macroContext, groupContext, parameters, path);
            }
        } else if (!(param.getType().equals((Object)AttributeTypeName.ENCRYPTED) || param.getType().equals((Object)AttributeTypeName.FILE) || param.getType().equals((Object)AttributeTypeName.CHANGE))) {
            AbstractParameter resolvedParameter = this.dataSetParameterProvider.getDataSetParameterResolved(macroContext.getDataSetListContext().getDataSetListId(), param.getParameterId(), param.getType(), true, macroContext, new ParameterPositionContext(Collections.emptyList(), dataset.getColumnNumber(), dataset.getId(), param.getOrder(), macroContext.getDataSetListContext().getDataSetListId()));
            parameters.add(new ExportPostmanParameter(path, resolvedParameter.getValue()));
        } else {
            parameters.add(new ExportPostmanParameter(path, ""));
        }
    }

    private String getPath(String attrPath, String paramName) {
        if (Strings.isNullOrEmpty((String)attrPath)) {
            return paramName;
        }
        return String.format("%s.%s", attrPath, paramName);
    }

    private void processGroup(ParameterContext param, MacroContext macroContext, GroupContext groupContext, List<ExportPostmanParameter> parameters, @Nullable String attrPath) {
        DataSetContext refDs = groupContext.getDataSets().stream().filter(ds -> ds.getName().equals(param.getValue())).findFirst().get();
        for (ParameterContext parameter : refDs.getParameters()) {
            this.processParameter(parameter, refDs, macroContext, groupContext.getGroups(), parameters, attrPath);
        }
    }
}

