/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetFileImporter {
    private static final Logger log = LoggerFactory.getLogger(DataSetFileImporter.class);
    private static final String DESCRIPTOR_FILE_NAME_REGEXP = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\.json";
    public static final String DELIMITER = "__";
    public static final int UUID_LENGTH = 36;
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final GridFsRepository gridFsRepoProvider;

    public void importFiles(Path workDir, ExportImportData importData) throws IOException {
        log.info("start importFiles(workDir: {})", (Object)workDir);
        Map<UUID, Path> list = this.getFileDescriptors(workDir, "files");
        log.debug("importFiles list: {}", list);
        list.forEach((id, path) -> {
            FileData fileData;
            log.debug("importFiles start import id: {}", id);
            if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
                HashMap map = new HashMap(importData.getReplacementMap());
                fileData = (FileData)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, FileData.class, map);
                fileData.setUrl("/attachment/" + fileData.getParameterUuid());
            } else {
                fileData = (FileData)this.objectLoaderFromDiskService.loadFileAsObject(path, FileData.class);
            }
            log.debug("importFiles import fileData: {}", (Object)fileData);
            if (fileData == null || fileData.getParameterUuid() == null) {
                log.info("Selected file is no a file descriptor. Path {}", (Object)path.toString());
                return;
            }
            String lettersName = fileData.getFileName();
            String fileName = Files.exists(path.getParent().resolve(lettersName), new LinkOption[0]) ? lettersName : id.toString();
            this.checkName(fileName);
            try (InputStream inputStream = Files.newInputStream(path.getParent().resolve(fileName), new OpenOption[0]);){
                this.gridFsRepoProvider.save(fileData, inputStream);
            }
            catch (Exception e) {
                log.info("Cannot read file from disk. File Data {}", (Object)fileData);
            }
        });
        log.info("end importFiles()");
    }

    private void checkName(String fileName) {
        if (fileName.contains(DELIMITER) && fileName.indexOf(DELIMITER) == 36) {
            throw new RuntimeException("Can not complete Import process due to the old zip archive version. Use the latest Datasets version.");
        }
    }

    private Map<UUID, Path> getFileDescriptors(Path workDir, String folderName) {
        Path dirWithObjects = workDir.resolve(folderName);
        log.debug("start getListOfObjectIdByFolder(dirWithObjects: {})", (Object)dirWithObjects);
        HashMap<UUID, Path> res = new HashMap<UUID, Path>();
        try (Stream<Path> result = Files.find(dirWithObjects, 5, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && this.isDescriptorFileName((Path)path), new FileVisitOption[0]);){
            result.forEach(pathToFile -> {
                UUID objectId;
                try {
                    objectId = UUID.fromString(pathToFile.getFileName().toString().split("\\.")[0]);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Can't get uuid from filename.", (Throwable)e);
                    return;
                }
                res.put(objectId, (Path)pathToFile);
            });
        }
        catch (Exception e) {
            log.error("Cannot find dir {}", (Object)dirWithObjects, (Object)e);
        }
        log.debug("end getListOfObjectIdByFolder(): {}", res);
        return res;
    }

    private boolean isDescriptorFileName(Path path) {
        return path.getFileName().toString().matches(DESCRIPTOR_FILE_NAME_REGEXP);
    }

    public DataSetFileImporter(ObjectLoaderFromDiskService objectLoaderFromDiskService, GridFsRepository gridFsRepoProvider) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.gridFsRepoProvider = gridFsRepoProvider;
    }
}

