/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import clover.com.google.common.collect.Lists;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.dataset.ei.model.AttributeKeyIdsDbUpdate;
import org.qubership.atp.dataset.ei.model.DataSet;
import org.qubership.atp.dataset.ei.model.DataSetAttribute;
import org.qubership.atp.dataset.ei.model.DataSetParameter;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetParametersImporter {
    private static final Logger log = LoggerFactory.getLogger(DataSetParametersImporter.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final JpaParameterService paramService;
    private final JpaAttributeService attrService;
    private final JpaDataSetService dsService;
    private final EntityManagerController entityManagerController;
    private final ClearCacheService clearCacheService;
    public static final String UUID_STRING = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";

    public void importDataSetParameters(Path workDir, ExportImportData importData) {
        log.info("start importDataSetParameters(workDir: {})", (Object)workDir);
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetParameter.class);
        log.debug("importDataSetParameters list: {}", (Object)list);
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                try {
                    this.importDataSetParameters((UUID)id, (Path)list.get(id), importData);
                }
                catch (RuntimeException e) {
                    log.error("Cannot import parameter {}", id, (Object)e);
                    throw e;
                }
            });
            this.entityManagerController.flushAndClear();
            log.info("Chunk with size {} completed. Total size {}.", (Object)chunk.size(), (Object)list.size());
        }
        log.info("end importDataSetParameters()");
    }

    private void importDataSetParameters(UUID id, Path path, ExportImportData importData) {
        Parameter parameter;
        DataSetParameter object;
        log.debug("importDataSetParameters start import id: {}", (Object)id);
        if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
            Map map = importData.getReplacementMap();
            object = (DataSetParameter)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetParameter.class, map);
        } else {
            object = (DataSetParameter)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetParameter.class);
        }
        log.debug("importDataSetParameters import object: {}", (Object)object);
        if (object == null) {
            String message = String.format("Cannot load file by path %s", path.toString());
            log.error(message);
            throw new RuntimeException(message);
        }
        UUID objAttributeId = object.getAttribute();
        AttributeKeyIdsDbUpdate attributeKeyIdFounded = this.attrService.getFoundedAttributeKeyIdAndDatasetIdUpdate().get(objAttributeId);
        UUID resultImportAttributeId = Objects.isNull(attributeKeyIdFounded) ? objAttributeId : attributeKeyIdFounded.getId();
        Attribute attribute = this.attrService.getById(resultImportAttributeId);
        log.debug("attribute: {}", (Object)attribute);
        if (attribute == null) {
            AttributeKey attributeKey = this.attrService.getAttributeKeyById(resultImportAttributeId);
            log.debug("attributeKey: {}", (Object)attributeKey);
            if (attributeKey == null) {
                return;
            }
        }
        if ((parameter = this.getParameter(object, attributeKeyIdFounded)) == null) {
            object.setSourceId(id);
            try {
                parameter = this.paramService.replicate(object.getId(), object.getDataSet(), object.getAttribute(), object.getSourceId());
                Map repMap = importData.getReplacementMap();
                this.replaceUuidsInMacrosStringInObject(object, repMap);
                this.updateParameter(parameter, object);
                this.paramService.save(parameter);
            }
            catch (DataSetServiceException e) {
                String message = String.format("Cannot create new parameter by import object %s", object);
                log.error(message, (Throwable)e);
                throw new ExportException(message, (Throwable)e);
            }
        } else {
            parameter.setDataSet(object.getDataSet());
            parameter.setAttribute(object.getAttribute());
            this.updateParameter(parameter, object);
            this.paramService.save(parameter);
        }
        this.clearCacheService.evictParameterCache(id);
    }

    private Parameter getParameter(DataSetParameter object, AttributeKeyIdsDbUpdate attributeKeyIdFounded) {
        Parameter parameter;
        if (Objects.nonNull(attributeKeyIdFounded)) {
            parameter = this.paramService.getParameterByAttributeIdAndDataSetId(attributeKeyIdFounded.getId(), attributeKeyIdFounded.getDataSetId());
            object.setDataSet(attributeKeyIdFounded.getDataSetId());
            object.setAttribute(attributeKeyIdFounded.getId());
        } else {
            parameter = this.paramService.getById(object.getId());
            if (Objects.isNull(parameter)) {
                parameter = this.paramService.getParameterByAttributeIdAndDataSetId(object.getAttribute(), object.getDataSet());
            }
        }
        return parameter;
    }

    private void replaceUuidsInMacrosStringInObject(DataSetParameter object, Map<UUID, UUID> repMap) {
        String parameterValue;
        if (Objects.nonNull(repMap) && !repMap.isEmpty() && !Strings.isNullOrEmpty((String)(parameterValue = object.getStringValue())) && parameterValue.contains("#REF")) {
            ArrayList<UUID> uuidsFromMacros = new ArrayList<UUID>();
            Pattern pattern = Pattern.compile(UUID_STRING);
            Matcher matcher = pattern.matcher(parameterValue);
            while (matcher.find()) {
                uuidsFromMacros.add(UUID.fromString(matcher.group()));
            }
            for (UUID uuidMacros : uuidsFromMacros) {
                UUID uuidMapValue = repMap.get(uuidMacros);
                if (!Objects.nonNull(uuidMapValue)) continue;
                parameterValue = parameterValue.replace(uuidMacros.toString(), uuidMapValue.toString());
            }
            object.setStringValue(parameterValue);
        }
    }

    private void updateParameter(Parameter parameter, DataSetParameter object) {
        org.qubership.atp.dataset.service.jpa.delegates.DataSet dataSet;
        parameter.setStringValue(object.getStringValue());
        parameter.setListValueId(object.getListValue());
        parameter.setFileValueId(object.getFileValueId());
        if (object.getDataSetReferenceValue() != null && (dataSet = this.dsService.getById(object.getDataSetReferenceValue())) != null) {
            parameter.setDataSetReferenceId(object.getDataSetReferenceValue());
        }
    }

    public List<UUID> getDsParameterIds(Path workDir) {
        return new ArrayList<UUID>(this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetParameter.class).keySet());
    }

    public List<String> validateDataSetParameters(Path workDir, Map<UUID, UUID> repMap, boolean isInterProjectImport) {
        log.info("start validateDataSetParameters(workDir: {})", (Object)workDir);
        HashSet result = new HashSet();
        Map dataSetParameters = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetParameter.class);
        Map dataSetAttributesWithoutReplacement = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttribute.class);
        Map dsIdsWithoutReplacement = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSet.class);
        Set dsIdsWithReplacement = isInterProjectImport ? dsIdsWithoutReplacement.keySet().stream().map(repMap::get).collect(Collectors.toSet()) : dsIdsWithoutReplacement.keySet();
        for (List chunk : Lists.partition(new ArrayList(dataSetParameters.keySet()), (int)1000)) {
            chunk.forEach(id -> this.validateDataSetParameters((UUID)id, (Path)dataSetParameters.get(id), dsIdsWithReplacement, dataSetAttributesWithoutReplacement, repMap, isInterProjectImport, result));
        }
        log.info("end validateDataSetParameters(result: {})", result);
        return new ArrayList<String>(result);
    }

    private void validateDataSetParameters(UUID id, Path path, Set<UUID> dsIdsWithReplacement, Map<UUID, Path> dataSetAttributesWithoutReplacement, Map<UUID, UUID> repMap, boolean isInterProjectImport, Set<String> result) {
        org.qubership.atp.dataset.service.jpa.delegates.DataSet dataSet;
        UUID attributeIdWithoutReplacement;
        DataSetParameter object;
        log.debug("validateDataSetParameters start validate id: {}", (Object)id);
        if (isInterProjectImport) {
            object = (DataSetParameter)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetParameter.class, repMap);
            DataSetParameter objectWithoutReplacement = (DataSetParameter)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetParameter.class);
            attributeIdWithoutReplacement = objectWithoutReplacement.getAttribute();
        } else {
            object = (DataSetParameter)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetParameter.class);
            attributeIdWithoutReplacement = object.getAttribute();
        }
        log.debug("validateDataSetParameters validate object: {}", (Object)object);
        if (object == null) {
            log.error("Cannot load file by path {}", (Object)path.toString());
            result.add("Some file cannot be loaded from import archive.");
            return;
        }
        if (object.getDataSetReferenceValue() != null && (dataSet = this.dsService.getById(object.getDataSetReferenceValue())) == null && !dsIdsWithReplacement.contains(object.getDataSetReferenceValue())) {
            DataSetAttribute attribute = (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObject(dataSetAttributesWithoutReplacement.get(attributeIdWithoutReplacement), DataSetAttribute.class);
            if (attribute == null) {
                String message = String.format("Cannot load file by path %s", path.toString());
                log.error(message);
                result.add(message);
                return;
            }
            log.error("Parameter {} refers to absent Data Set {}", (Object)object, (Object)object.getDataSetReferenceValue());
            result.add("Some Link to Data Set Attribute refers to absent Data Set.");
        }
    }

    public void fillRepMapWithSourceTargetValues(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetParameter.class);
        for (List chunk : Lists.partition(new ArrayList(objectsToImport.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                if (!replacementMap.containsKey(id)) {
                    DataSetParameter object = (DataSetParameter)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), DataSetParameter.class);
                    List<Parameter> existingObject = this.paramService.getBySourceIdAndDataSetId((UUID)id, (UUID)replacementMap.get(object.getDataSet()));
                    if (CollectionUtils.isEmpty(existingObject)) {
                        replacementMap.put((UUID)id, (UUID)null);
                    } else {
                        replacementMap.put((UUID)id, existingObject.get(0).getId());
                    }
                }
            });
        }
    }

    public DataSetParametersImporter(ObjectLoaderFromDiskService objectLoaderFromDiskService, JpaParameterService paramService, JpaAttributeService attrService, JpaDataSetService dsService, EntityManagerController entityManagerController, ClearCacheService clearCacheService) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.paramService = paramService;
        this.attrService = attrService;
        this.dsService = dsService;
        this.entityManagerController = entityManagerController;
        this.clearCacheService = clearCacheService;
    }
}

