/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import clover.com.google.common.collect.Lists;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.dataset.ei.model.DataSet;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetsImporter {
    private static final Logger log = LoggerFactory.getLogger(DataSetsImporter.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final JpaDataSetService dsService;
    private final JpaDataSetListService dslService;
    private final DuplicateNameChecker duplicateNameChecker;
    private final EntityManagerController entityManagerController;
    private final ClearCacheService clearCacheService;

    public void importDataSets(Path workDir, ExportImportData importData) {
        log.info("start importDataSets(workDir: {})", (Object)workDir);
        HashMap maxOrdering = new HashMap();
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSet.class);
        log.debug("importDataSets list: {}", (Object)list);
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                try {
                    this.importDataSets((UUID)id, (Path)list.get(id), maxOrdering, importData);
                }
                catch (RuntimeException e) {
                    log.error("Cannot import dataset {}", id, (Object)e);
                    throw e;
                }
            });
            this.entityManagerController.flushAndClear();
            log.info("Chunk with size {} completed. Total size {}.", (Object)chunk.size(), (Object)list.size());
        }
        log.info("end importDataSets()");
    }

    private void importDataSets(UUID id, Path path, Map<UUID, Long> maxOrdering, ExportImportData importData) {
        DataSet object;
        log.debug("importDataSets start import id: {}", (Object)id);
        if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
            HashMap map = new HashMap(importData.getReplacementMap());
            object = (DataSet)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSet.class, map);
        } else {
            object = (DataSet)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSet.class);
        }
        log.debug("import object: {}", (Object)object);
        if (object == null) {
            String message = String.format("Cannot load file by path %s", path.toString());
            log.error(message);
            throw new RuntimeException(message);
        }
        org.qubership.atp.dataset.service.jpa.delegates.DataSet dataSet = this.dsService.getById(object.getId());
        Long order = this.calculateOrder(maxOrdering, object);
        if (dataSet == null) {
            object.setSourceId(id);
            this.createWithCheckName(object, order);
        } else {
            this.updateWithCheckName(dataSet, object, order);
        }
        this.duplicateNameChecker.addToCache(object.getDataSetList(), object);
        this.clearCacheService.evictDatasetListContextCache(id);
    }

    private Long calculateOrder(Map<UUID, Long> maxOrdering, DataSet object) {
        try {
            if (!maxOrdering.containsKey(object.getDataSetList())) {
                DataSetList dsl = this.dslService.getById(object.getDataSetList());
                maxOrdering.put(object.getDataSetList(), dsl.getLastDataSetsOrderNumber());
            }
            return maxOrdering.get(object.getDataSetList()) + object.getOrdering();
        }
        catch (Exception e) {
            log.error("Unable calculate order for dataset = [{}], maxOrdering = [{}]", new Object[]{object, maxOrdering, e});
            throw e;
        }
    }

    private void updateWithCheckName(org.qubership.atp.dataset.service.jpa.delegates.DataSet dataSet, DataSet object, Long order) {
        this.checkAndCorrectName(object);
        dataSet.setName(object.getName());
        dataSet.setDataSetList(object.getDataSetList());
        dataSet.setOrdering(order);
        dataSet.setLocked(this.isDataSetLocked(object));
        log.debug("[importDataSets][save DataSet] dataSet: {}", (Object)dataSet);
        this.dsService.save(dataSet);
    }

    private void createWithCheckName(DataSet object, Long order) {
        this.checkAndCorrectName(object);
        try {
            this.dsService.replicate(object.getId(), object.getName(), object.getDataSetList(), order, object.getSourceId(), this.isDataSetLocked(object));
        }
        catch (DataSetServiceException e) {
            String message = String.format("Cannot create new data set by import object %s", object);
            throw new ExportException(message, (Throwable)e);
        }
    }

    private boolean isDataSetLocked(DataSet dataSet) {
        return dataSet.getIsLocked() != null && dataSet.getIsLocked() != false;
    }

    public void checkAndCorrectName(DataSet object) {
        this.initCache(object.getDataSetList());
        this.duplicateNameChecker.checkAndCorrectName(object.getDataSetList(), object);
    }

    private boolean isNameUsed(DataSet object, UUID dsListId) {
        this.initCache(dsListId);
        return this.duplicateNameChecker.isNameUsed(dsListId, object);
    }

    private void initCache(UUID dsListId) {
        if (!this.duplicateNameChecker.isInitialized(DataSet.class, dsListId)) {
            HashMultimap initMap = HashMultimap.create();
            this.dsService.getByDataSetListId(dsListId).forEach(arg_0 -> DataSetsImporter.lambda$initCache$1((Multimap)initMap, arg_0));
            this.duplicateNameChecker.init(DataSet.class, dsListId, (Multimap<String, UUID>)initMap);
        }
    }

    public List<UUID> getDsIds(Path workDir) {
        return new ArrayList<UUID>(this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSet.class).keySet());
    }

    public Collection<? extends String> validateDataSets(Path workDir, Map<UUID, UUID> repMap, boolean isInterProjectImport) {
        HashSet result = new HashSet();
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSet.class);
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> this.validateDataSets((UUID)id, (Path)list.get(id), repMap, isInterProjectImport, result));
        }
        return new ArrayList(result);
    }

    private void validateDataSets(UUID id, Path path, Map<UUID, UUID> repMap, boolean isInterProjectImport, Set<String> result) {
        log.debug("validateDataSets start import id: {}", (Object)id);
        DataSet object = isInterProjectImport ? (DataSet)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSet.class, repMap) : (DataSet)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSet.class);
        log.debug("validate object: {}", (Object)object);
        if (object == null) {
            log.error("Cannot load file by path {}", (Object)path.toString());
            result.add("Some file cannot be loaded from import archive.");
            return;
        }
        if (this.isNameUsed(object, object.getDataSetList())) {
            DataSetList dataSetList = this.dslService.getById(object.getDataSetList());
            result.add(String.format("Data Set with name '%s' already exists in the data set list '%s'. Imported one will be renamed to '%s Copy'.", object.getName(), dataSetList.getName(), object.getName()));
        }
    }

    public void fillRepMapWithSourceTargetValues(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSet.class);
        for (List chunk : Lists.partition(new ArrayList(objectsToImport.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                if (!replacementMap.containsKey(id)) {
                    DataSet object = (DataSet)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), DataSet.class);
                    List<org.qubership.atp.dataset.service.jpa.delegates.DataSet> existingObject = this.dsService.getBySourceAndDataSetListId((UUID)id, (UUID)replacementMap.get(object.getDataSetList()));
                    if (CollectionUtils.isEmpty(existingObject)) {
                        replacementMap.put((UUID)id, (UUID)null);
                    } else {
                        replacementMap.put((UUID)id, existingObject.get(0).getId());
                    }
                }
            });
        }
    }

    public DataSetsImporter(ObjectLoaderFromDiskService objectLoaderFromDiskService, JpaDataSetService dsService, JpaDataSetListService dslService, DuplicateNameChecker duplicateNameChecker, EntityManagerController entityManagerController, ClearCacheService clearCacheService) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.dsService = dsService;
        this.dslService = dslService;
        this.duplicateNameChecker = duplicateNameChecker;
        this.entityManagerController = entityManagerController;
        this.clearCacheService = clearCacheService;
    }

    private static /* synthetic */ void lambda$initCache$1(Multimap initMap, org.qubership.atp.dataset.service.jpa.delegates.DataSet entity) {
        initMap.put((Object)entity.getName(), (Object)entity.getId());
    }
}

