/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.ei.model.IdEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateNameChecker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateNameChecker.class);
    private ThreadLocal<Map<String, Multimap<String, UUID>>> existingNamesCache = ThreadLocal.withInitial(HashMap::new);

    public void init(Class clazz, UUID parentId, Multimap<String, UUID> map) {
        String key = this.getKey(clazz, parentId);
        this.existingNamesCache.get().put(key, (Multimap<String, UUID>)HashMultimap.create(map));
    }

    public boolean isInitialized(Class clazz, UUID parentId) {
        String key = this.getKey(clazz, parentId);
        return this.existingNamesCache.get().containsKey(key);
    }

    public boolean isNameUsed(UUID parentId, IdEntity object) {
        String key = this.getKey(object.getClass(), parentId);
        return this.existingNamesCache.get().containsKey(key) && this.existingNamesCache.get().get(key).containsKey((Object)object.getName()) && !this.existingNamesCache.get().get(key).get((Object)object.getName()).contains(object.getId());
    }

    public void checkAndCorrectName(UUID parentId, IdEntity object) {
        int i = 0;
        String initName = object.getName();
        while (this.isNameUsed(parentId, object)) {
            String newName = i == 0 ? (initName = object.getName() + " Copy") : initName + " _" + i;
            object.setName(newName);
            ++i;
        }
    }

    public void addToCache(UUID parentId, IdEntity object) {
        String key = this.getKey(object.getClass(), parentId);
        if (!this.existingNamesCache.get().containsKey(key)) {
            log.debug("[!existingNamesCache] when cache no contains key. Object Name{}, object Id{}, existingNamesCache:{}", new Object[]{object.getName(), object.getId(), this.existingNamesCache.get()});
            this.existingNamesCache.get().put(key, (Multimap<String, UUID>)HashMultimap.create());
        }
        this.existingNamesCache.get().get(key).put((Object)object.getName(), (Object)object.getId());
    }

    public void clearCache() {
        this.existingNamesCache.remove();
    }

    private String getKey(Class clazz, UUID parentId) {
        return clazz.getSimpleName() + parentId;
    }
}

