/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.kafka.listeners;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import org.qubership.atp.dataset.kafka.entities.project.ProjectEvent;
import org.qubership.atp.dataset.kafka.handlers.KafkaEventHandler;
import org.qubership.atp.integration.configuration.mdc.MdcField;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, matchIfMissing=false)
public class ProjectEventListener {
    private static final String KAFKA_LISTENER_ID = "datasetProjectEvent";
    private final ObjectMapper objectMapper;
    private final KafkaEventHandler<ProjectEvent> projectEventHandler;

    @Autowired
    public ProjectEventListener(KafkaEventHandler<ProjectEvent> projectEventHandler, @Qualifier(value="ignoreUnknownPropertiesMapper") ObjectMapper objectMapper) {
        this.projectEventHandler = projectEventHandler;
        this.objectMapper = objectMapper;
    }

    @KafkaListener(id="datasetProjectEvent", topics={"${kafka.project.event.consumer.topic.name}"}, containerFactory="projectEventContainerFactory")
    public void listen(@Payload String event) throws IOException {
        MDC.clear();
        ProjectEvent projectEvent = (ProjectEvent)this.objectMapper.readValue(event, ProjectEvent.class);
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectEvent.getProjectId());
        this.projectEventHandler.handle(projectEvent);
    }

    public ProjectEventListener(ObjectMapper objectMapper, KafkaEventHandler<ProjectEvent> projectEventHandler) {
        this.objectMapper = objectMapper;
        this.projectEventHandler = projectEventHandler;
    }
}

