/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.Macros;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MacroRegistryImpl
implements MacroRegistry {
    private final Map<String, Macros> macroses;
    @Autowired
    private List<Macros> macrosList;

    public MacroRegistryImpl() {
        this(new HashMap<String, Macros>());
    }

    public MacroRegistryImpl(Map<String, Macros> macroses) {
        this.macroses = macroses;
    }

    @Override
    public boolean fullyEquals(String name) {
        name = name.toUpperCase();
        for (String macro : this.macroses.keySet()) {
            if (!name.equals(macro)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean partiallyEquals(String to) {
        to = to.toUpperCase();
        for (String macro : this.macroses.keySet()) {
            if (!macro.startsWith(to)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Macros getMacros(@Nonnull String key) {
        Macros macros = this.macroses.get(key.toUpperCase());
        assert (macros != null);
        return macros;
    }

    @PostConstruct
    public void init() {
        this.macrosList.stream().forEach(x -> this.macroses.put(x.getDefinition().toUpperCase(), (Macros)x));
    }
}

