/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.args;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.Position;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.macros.args.MacroArgFactory;
import org.qubership.atp.dataset.macros.args.MacroArgFactoryImpl;
import org.qubership.atp.dataset.macros.args.MacroArgsFactory;
import org.qubership.atp.dataset.macros.args.SignatureArg;

public abstract class DotSeparatedArgsParser
implements ArgsParser {
    private final String delimeter;
    private final int delimeterLength;
    private final MacroArgsFactory factory;
    protected State state = new State();

    protected DotSeparatedArgsParser(MacroArgsFactory factory) {
        this(".", factory);
    }

    private DotSeparatedArgsParser(String delimeter, MacroArgsFactory factory) {
        this.delimeter = delimeter;
        this.delimeterLength = delimeter.length();
        this.factory = factory;
    }

    protected abstract SignatureArg createArg(int var1, @Nonnull MacroArgFactory var2) throws Exception;

    @Override
    public void append(CharSequence text) {
        this.state.tail.append(text);
    }

    @Override
    public void clear() {
        this.state.reset();
    }

    @Override
    public ArgsParser.Result tryParse() {
        State backup = this.state.copy();
        try {
            backup.tryParse();
            this.state = backup;
        }
        catch (Exception e) {
            this.state.error = e;
        }
        return this.state;
    }

    public String toString() {
        return this.state.toString();
    }

    @Override
    public ArgsParser.Result parseToTheEnd() {
        this.tryParse();
        if (this.state.tail.length() == 0 || this.state.error != null) {
            this.state.fullyParsed = true;
            return this.state;
        }
        try {
            this.state.parseTail();
            this.state.fullyParsed = true;
        }
        catch (Exception e) {
            this.state.error = e;
        }
        return this.state;
    }

    private class State
    extends MacroArgFactoryImpl
    implements ArgsParser.Result {
        protected final List<SignatureArg> parsed;
        final StringBuilder tail;
        protected Exception error;
        protected int offset;
        int curArgIndex;
        boolean fullyParsed;

        State() {
            this(new StringBuilder(), Lists.newArrayListWithExpectedSize((int)3), null, 0, 0, false);
        }

        State(StringBuilder tail, List<SignatureArg> parsed, Exception error, int offset, int curArgIndex, boolean fullyParsed) {
            super(DotSeparatedArgsParser.this.factory);
            this.tail = tail;
            this.parsed = parsed;
            this.error = error;
            this.offset = offset;
            this.curArgIndex = curArgIndex;
            this.fullyParsed = fullyParsed;
        }

        State copy() {
            return new State(new StringBuilder(this.tail), new ArrayList<SignatureArg>(this.parsed), this.error, this.offset, this.curArgIndex, this.fullyParsed);
        }

        void reset() {
            this.tail.setLength(0);
            this.parsed.clear();
            this.error = null;
            this.offset = 0;
            this.curArgIndex = 0;
        }

        void tryParse() throws Exception {
            int delimIdx = this.tail.indexOf(DotSeparatedArgsParser.this.delimeter);
            while (delimIdx != -1) {
                SignatureArg arg = DotSeparatedArgsParser.this.createArg(this.curArgIndex++, this.withText(new Position(this.offset, this.offset + delimIdx), this.tail.substring(0, delimIdx)));
                this.parsed.add(arg);
                int end = delimIdx + DotSeparatedArgsParser.this.delimeterLength;
                this.tail.delete(0, end);
                this.offset += end;
                delimIdx = this.tail.indexOf(DotSeparatedArgsParser.this.delimeter);
            }
        }

        void parseTail() throws Exception {
            SignatureArg arg = DotSeparatedArgsParser.this.createArg(this.curArgIndex++, this.withText(new Position(this.offset, this.offset + this.tail.length()), this.tail.toString()));
            this.tail.setLength(0);
            this.parsed.add(arg);
        }

        @Override
        public Optional<Exception> getError() {
            return Optional.ofNullable(this.error);
        }

        @Override
        public Optional<String> getUnparsed() {
            return this.tail.length() == 0 ? Optional.empty() : Optional.of(this.tail.toString());
        }

        @Override
        public List<SignatureArg> getParsed() {
            return this.parsed;
        }

        public String toString() {
            Stream<String> args = this.parsed.stream().map(MacroArg::getText);
            if (!this.fullyParsed) {
                args = Stream.concat(args, Stream.of(this.tail.toString()));
            }
            return args.collect(Collectors.joining(DotSeparatedArgsParser.this.delimeter));
        }
    }
}

