/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DumbArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.springframework.stereotype.Component;

@Component
public class DateMacros
extends Macros<String> {
    private static final String REGEX = "^([+-]\\d+\\w)+?,(.+)";

    public DateMacros() {
        super("DATE");
    }

    @Override
    public String evaluate(Stream<? extends MacroArg> input, EvaluationContext context) throws Exception {
        String dataExpression = input.findAny().orElseThrow(() -> new IllegalArgumentException("One argument expected")).getText();
        if (dataExpression.matches(REGEX)) {
            return this.formattedCalculatedDate(dataExpression, new DateTime());
        }
        return this.formattedDate(dataExpression, DateTime.now());
    }

    @Override
    public ArgsParser createArgsParser() {
        return new DumbArgsParser();
    }

    @Override
    public boolean doCache() {
        return true;
    }

    private String formattedDate(String dataExpression, DateTime dateTimeNow) {
        return dateTimeNow.toString(DateTimeFormat.forPattern((String)dataExpression));
    }

    protected String formattedCalculatedDate(String matcher, DateTime dateTimeNow) {
        List list = Splitter.on((char)',').limit(2).trimResults().splitToList((CharSequence)matcher);
        String calculationPatterns = (String)list.get(0);
        String dateFormatPattern = (String)list.get(1);
        dateTimeNow = this.calculate(calculationPatterns, dateTimeNow);
        return dateTimeNow.toString(DateTimeFormat.forPattern((String)dateFormatPattern));
    }

    private DateTime calculate(String calculationPatterns, DateTime dateTime) {
        Matcher matcher = Pattern.compile("[+-]\\d+\\w").matcher(calculationPatterns);
        while (matcher.find()) {
            dateTime = this.calculateDate(dateTime, matcher.group());
        }
        return dateTime;
    }

    public DateTime calculateDate(DateTime dateTime, String entry) {
        Operation operation = entry.charAt(0) == '-' ? Operation.MINUS : Operation.PLUS;
        int capacity = Integer.parseInt(entry.substring(1, entry.length() - 1));
        dateTime = this.doOperation(dateTime, entry, operation, capacity);
        return dateTime;
    }

    private DateTime doOperation(DateTime dateTime, String entry, Operation operation, int capacity) {
        char charAt = entry.charAt(entry.length() - 1);
        switch (charAt) {
            case 'd': {
                return operation.calc(dateTime, (ReadablePeriod)Days.days((int)capacity));
            }
            case 'h': {
                return operation.calc(dateTime, (ReadablePeriod)Hours.hours((int)capacity));
            }
            case 'm': {
                return operation.calc(dateTime, (ReadablePeriod)Minutes.minutes((int)capacity));
            }
            case 's': {
                return operation.calc(dateTime, (ReadablePeriod)Seconds.seconds((int)capacity));
            }
            case 'M': {
                return operation.calc(dateTime, (ReadablePeriod)Months.months((int)capacity));
            }
            case 'y': {
                return operation.calc(dateTime, (ReadablePeriod)Years.years((int)capacity));
            }
        }
        throw new IllegalArgumentException("Undefined type of date operation: " + operation.operationSign + charAt);
    }

    private static enum Operation {
        PLUS('+'){

            @Override
            public DateTime calc(DateTime dateTime, ReadablePeriod period) {
                return dateTime.plus(period);
            }
        }
        ,
        MINUS('-'){

            @Override
            public DateTime calc(DateTime dateTime, ReadablePeriod period) {
                return dateTime.minus(period);
            }
        };

        private char operationSign;

        private Operation(char operationSign) {
            this.operationSign = operationSign;
        }

        public abstract DateTime calc(DateTime var1, ReadablePeriod var2);
    }
}

