/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Stream;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DumbArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.springframework.stereotype.Component;

@Component
public class RandomBetweenMacros
extends Macros<Long> {
    public RandomBetweenMacros() {
        super("RANDOMBETWEEN");
    }

    @Override
    public Long evaluate(Stream<? extends MacroArg> input, EvaluationContext context) throws Exception {
        String text = input.findAny().orElseThrow(() -> new IllegalArgumentException("One argument expected")).getText();
        List list = Splitter.on((char)',').trimResults().splitToList((CharSequence)text);
        this.validateArgument(list);
        long min = this.getLong((String)list.get(0));
        long max = this.getLong((String)list.get(1));
        return min + (long)(Math.random() * (double)(max - min + 1L));
    }

    @Override
    public ArgsParser createArgsParser() {
        return new DumbArgsParser();
    }

    @Override
    public boolean doCache() {
        return true;
    }

    private void validateArgument(List<String> list) {
        Preconditions.checkArgument((list.size() == 2 ? 1 : 0) != 0, (Object)("Unable to evaluate RANDOMBETWEEN macros, due to invalid count of arguments received. Args: " + list));
    }

    private long getLong(String input) {
        Preconditions.checkArgument((input != null && input.matches("\\d+") ? 1 : 0) != 0, (Object)("Invalid argument of RANDOMBETWEEN macros. Expected numeric, but received: " + input));
        return Long.parseLong(input);
    }
}

