/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl.reference;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.service.direct.IdentifiedService;

public abstract class ReferenceAliasType<T extends Identified & Named> {
    public static final ReferenceAliasType<DataSetList> DSL;
    public static final ReferenceAliasType<DataSet> DS;
    public static final ReferenceAliasType<Attribute> ATTR;
    private static final Set<ReferenceAliasType> VALUES;
    private static final String EXPECTED_VALUES;
    private final short id;
    private final String name;

    public ReferenceAliasType(short id, String name) {
        this.id = id;
        this.name = name;
    }

    public static ReferenceAliasType from(short id) {
        for (ReferenceAliasType type : VALUES) {
            if (type.getId() != id) continue;
            return type;
        }
        throw new IllegalArgumentException("Undefined reference type with id: " + id + ". Expected: " + EXPECTED_VALUES);
    }

    @JsonCreator
    public static ReferenceAliasType from(@Nonnull String name) {
        for (ReferenceAliasType type : VALUES) {
            if (!name.equals(type.name())) continue;
            return type;
        }
        throw new IllegalArgumentException("Undefined reference type with name: " + name + ". Expected: " + EXPECTED_VALUES);
    }

    @Nonnull
    private static String buildNames(@Nonnull Iterable<ReferenceAliasType> values) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (ReferenceAliasType type : values) {
            builder.append(type.name()).append('(').append(type.getId()).append(')').append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        return builder.toString();
    }

    public static Set<ReferenceAliasType> values() {
        return VALUES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceAliasType)) {
            return false;
        }
        ReferenceAliasType that = (ReferenceAliasType)o;
        return this.getId() == that.getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public Optional<DataSetList> asDsl(@Nonnull T instance) {
        return Optional.empty();
    }

    public Optional<DataSet> asDs(@Nonnull T instance) {
        return Optional.empty();
    }

    public Optional<Attribute> asAttr(@Nonnull T instance) {
        return Optional.empty();
    }

    @Nonnull
    public abstract IdentifiedService<T> chooseService(@Nonnull IdentifiedService<DataSetList> var1, @Nonnull IdentifiedService<DataSet> var2, @Nonnull IdentifiedService<Attribute> var3);

    public short getId() {
        return this.id;
    }

    @JsonValue
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        ReferenceAliasType<DataSetList> dsl = new ReferenceAliasType<DataSetList>(1, "DSL"){

            @Override
            public Optional<DataSetList> asDsl(@Nonnull DataSetList instance) {
                return Optional.of(instance);
            }

            @Override
            @Nonnull
            public IdentifiedService<DataSetList> chooseService(@Nonnull IdentifiedService<DataSetList> dslService, @Nonnull IdentifiedService<DataSet> dsService, @Nonnull IdentifiedService<Attribute> attrService) {
                return dslService;
            }
        };
        ReferenceAliasType<DataSet> ds = new ReferenceAliasType<DataSet>(2, "DS"){

            @Override
            public Optional<DataSet> asDs(@Nonnull DataSet instance) {
                return Optional.of(instance);
            }

            @Override
            @Nonnull
            public IdentifiedService<DataSet> chooseService(@Nonnull IdentifiedService<DataSetList> dslService, @Nonnull IdentifiedService<DataSet> dsService, @Nonnull IdentifiedService<Attribute> attrService) {
                return dsService;
            }
        };
        ReferenceAliasType<Attribute> attr = new ReferenceAliasType<Attribute>(3, "ATTR"){

            @Override
            public Optional<Attribute> asAttr(@Nonnull Attribute instance) {
                return Optional.of(instance);
            }

            @Override
            @Nonnull
            public IdentifiedService<Attribute> chooseService(@Nonnull IdentifiedService<DataSetList> dslService, @Nonnull IdentifiedService<DataSet> dsService, @Nonnull IdentifiedService<Attribute> attrService) {
                return attrService;
            }
        };
        DSL = dsl;
        DS = ds;
        ATTR = attr;
        VALUES = ImmutableSet.of((Object)dsl, (Object)ds, (Object)attr);
        EXPECTED_VALUES = ReferenceAliasType.buildNames(VALUES);
    }
}

