/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.parser;

import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.parser.OpenBrackets;
import org.qubership.atp.dataset.macros.parser.ParsingState;
import org.qubership.atp.dataset.macros.parser.Strategy;
import org.qubership.atp.dataset.macros.parser.TerminalStrat;
import org.qubership.atp.dataset.macros.parser.TextPartStrat;
import org.qubership.atp.dataset.macros.parser.TokenType;

class ProbablyFormulaStrat
extends Strategy {
    private final MacroRegistry macroFinder;
    private final OpenBrackets brackets;
    private final ParsingState parsingState;
    private final StringBuilder buffer = new StringBuilder();
    private TextPartStrat prefix = null;

    ProbablyFormulaStrat(ParsingState parsingState, MacroRegistry macroFinder, OpenBrackets brackets) {
        super(TokenType.PROBABLY_FORMULA);
        this.parsingState = parsingState;
        this.macroFinder = macroFinder;
        this.brackets = brackets;
    }

    @Override
    public Strategy read(char chr) {
        if (chr == '(' && this.macroFinder.fullyEquals(this.buffer.toString())) {
            if (this.prefix != null) {
                this.parsingState.pushToken(this.parsingState.textPart);
            }
            TerminalStrat formulaStarted = this.parsingState.formulaStart.of(this.buffer);
            this.parsingState.pushToken(formulaStarted);
            this.brackets.goDeeper();
            return formulaStarted;
        }
        if (this.macroFinder.partiallyEquals(this.buffer.toString() + chr)) {
            this.buffer.append(chr);
            return this;
        }
        this.buffer.insert(0, '#');
        if (this.prefix != null) {
            return this.prefix.append(this.buffer).read(chr);
        }
        return this.parsingState.textPart.of(this.buffer).read(chr);
    }

    @Override
    public String getValue() {
        String result = '#' + this.buffer.toString();
        if (this.prefix == null) {
            return result;
        }
        return this.prefix.getValue() + result;
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.prefix = null;
        this.buffer.setLength(0);
    }

    ProbablyFormulaStrat noPrefix() {
        this.clearState();
        return this;
    }

    ProbablyFormulaStrat withPrefix(TextPartStrat prefix) {
        ProbablyFormulaStrat result = this.noPrefix();
        result.prefix = prefix;
        return result;
    }
}

