/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.parser;

import org.qubership.atp.dataset.macros.parser.OpenBrackets;
import org.qubership.atp.dataset.macros.parser.ParsingState;
import org.qubership.atp.dataset.macros.parser.Strategy;
import org.qubership.atp.dataset.macros.parser.TerminalStrat;
import org.qubership.atp.dataset.macros.parser.TokenType;

class TextPartStrat
extends Strategy {
    private final OpenBrackets brackets;
    private final StringBuilder buffer = new StringBuilder();
    private final ParsingState parsingState;

    TextPartStrat(ParsingState parsingState, OpenBrackets brackets) {
        super(TokenType.TEXT_PART);
        this.parsingState = parsingState;
        this.brackets = brackets;
    }

    @Override
    public Strategy read(char chr) {
        if (chr == ')') {
            if (this.brackets.getOpen() == 0) {
                TerminalStrat formulaEnded = this.parsingState.formulaEnd.of(this.buffer);
                this.parsingState.pushToken(formulaEnded);
                this.brackets.goUpper();
                return formulaEnded;
            }
            this.brackets.decOpen();
        }
        if (chr == '#') {
            return this.parsingState.probablyFormula.withPrefix(this);
        }
        if (chr == '(') {
            this.brackets.incOpen();
        }
        this.buffer.append(chr);
        return this;
    }

    @Override
    public String getValue() {
        return this.buffer.toString();
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.buffer.setLength(0);
    }

    TextPartStrat of() {
        this.clearState();
        return this;
    }

    TextPartStrat of(CharSequence chr) {
        TextPartStrat result = this.of();
        result.append(chr);
        return this;
    }

    TextPartStrat append(CharSequence postfix) {
        this.buffer.append(postfix);
        return this;
    }
}

